/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.greplogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogConsumer {
    private final List<Pattern> expectedExceptions = new ArrayList<Pattern>();
    private boolean skipLogMsgs = false;
    private boolean infoMsgFlag = false;
    private int eatLines = 0;
    private boolean tmpErrFlag = false;
    private int tmpErrLines = 0;
    private boolean saveFlag = false;
    private int savelinenum = 0;
    private final List<Pattern> testExpectStrs;
    private StringBuilder all = null;
    private int lineNumber;
    private String fileName;
    private HashMap<String, Integer> individualErrorCount = new HashMap();
    private final int repeatLimit;
    private static final Pattern ExpectedExceptionPattern = Pattern.compile("<ExpectedException action=(add|remove)>(.*)</ExpectedException>");
    private static final Pattern logPattern = Pattern.compile("^\\[(?:fatal|error|warn|info|debug|trace|severe|warning|fine|finer|finest)");
    private static final Pattern blankPattern = Pattern.compile("^\\s*$");
    private static final Pattern skipLevelPattern = Pattern.compile("^\\[(?:warn|warning|info|debug|trace|fine|finer|finest)");
    private static final Pattern fatalOrErrorPattern = Pattern.compile("^\\[(?:fatal|error|severe)");
    private static final Pattern causedByPattern = Pattern.compile("Caused by");
    private static final Pattern shortErrPattern = Pattern.compile("^\\[[^\\]]+\\](.*)$", 40);
    private static final Pattern wroteExceptionPattern = Pattern.compile("\\[debug.*Wrote exception:");
    private static final Pattern rmiWarnPattern = Pattern.compile("^WARNING: Failed to .*java.rmi.ConnectException: Connection refused to host: .*; nested exception is:");
    private static final Pattern javaLangErrorPattern = Pattern.compile("^java\\.lang\\.\\S+Error$");
    private static final Pattern exceptionPattern = Pattern.compile("Exception:");
    private static final Pattern exceptionPattern2 = Pattern.compile("( [\\w\\.]+Exception: (([\\S]+ ){0,6}))");
    private static final Pattern exceptionPattern3 = Pattern.compile("( [\\w\\.]+Exception)$");
    private static final Pattern exceptionPattern4 = Pattern.compile("^([^:]+: (([\\w\"]+ ){0,6}))");
    private static final Pattern misformatedI18nMessagePattern = Pattern.compile("[^\\d]\\{\\d+\\}");
    private static final Pattern rvvBitSetMessagePattern = Pattern.compile("RegionVersionVector.+bsv\\d+.+bs=\\{\\d+\\}");
    private static int ERROR_BUFFER_LIMIT = 128;

    public LogConsumer(boolean skipLogMsgs, List<Pattern> testExpectStrs, String fileName, int repeatLimit) {
        this.skipLogMsgs = skipLogMsgs;
        this.testExpectStrs = testExpectStrs;
        this.fileName = fileName;
        this.repeatLimit = repeatLimit;
    }

    public StringBuilder consume(CharSequence line) {
        ++this.lineNumber;
        Matcher expectedExceptionMatcher = ExpectedExceptionPattern.matcher(line);
        if (expectedExceptionMatcher.find()) {
            this.expectedExceptionMatcherHandler(expectedExceptionMatcher);
            return null;
        }
        if (this.skipLogMsgs && this.skipThisLogMsg(line)) {
            return null;
        }
        if (this.eatLines != 0) {
            --this.eatLines;
            return null;
        }
        if (this.saveFlag || fatalOrErrorPattern.matcher(line).find()) {
            if (!this.saveFlag) {
                this.setInstanceVariablesForSomeReason(line);
            } else {
                if (!causedByPattern.matcher(line).find() && this.checkExpectedStrs(line, this.expectedExceptions)) {
                    this.tmpErrFlag = false;
                    this.tmpErrLines = 0;
                    this.saveFlag = false;
                }
                if (blankPattern.matcher(line).matches()) {
                    return this.enforceErrorLimitsAtShortErrMatcher();
                }
                if (this.tmpErrFlag) {
                    this.addErrLinesToAll(line);
                }
            }
        } else {
            if (this.isWroteOrRMIWarn(line)) {
                this.handleWroteOrRMIWarn();
                return null;
            }
            if (this.isExceptionErrorOrSomeSpecialCase(line) && !this.checkExpectedStrs(line, this.expectedExceptions)) {
                return this.enforceErrorLimitOnShortName(line);
            }
        }
        return null;
    }

    private void handleWroteOrRMIWarn() {
        this.eatLines = 1;
    }

    private boolean isWroteOrRMIWarn(CharSequence line) {
        return wroteExceptionPattern.matcher(line).find() || rmiWarnPattern.matcher(line).find();
    }

    private StringBuilder enforceErrorLimitOnShortName(CharSequence line) {
        String shortName = this.getShortName(line);
        if (shortName != null) {
            Integer i = this.individualErrorCount.get(shortName);
            int occurrences = i == null ? 1 : i + 1;
            this.individualErrorCount.put(shortName, occurrences);
            return this.enforceErrorLimit(occurrences, line + "\n", this.lineNumber, this.fileName);
        }
        return this.enforceErrorLimit(1, line + "\n", this.lineNumber, this.fileName);
    }

    private boolean isExceptionErrorOrSomeSpecialCase(CharSequence line) {
        return exceptionPattern.matcher(line).find() || javaLangErrorPattern.matcher(line).find() || misformatedI18nMessagePattern.matcher(line).find() && (!skipLevelPattern.matcher(line).find() || !rvvBitSetMessagePattern.matcher(line).find());
    }

    private void addErrLinesToAll(CharSequence line) {
        if (this.tmpErrLines < ERROR_BUFFER_LIMIT) {
            ++this.tmpErrLines;
            this.all.append(line).append("\n");
        }
        if (this.tmpErrLines == ERROR_BUFFER_LIMIT) {
            ++this.tmpErrLines;
            this.all.append("GrepLogs: ERROR_BUFFER_LIMIT limit reached,").append(" the error was too long to display completely.\n");
        }
    }

    private StringBuilder enforceErrorLimitsAtShortErrMatcher() {
        this.saveFlag = false;
        Matcher shortErrMatcher = shortErrPattern.matcher(this.all.toString());
        if (shortErrMatcher.matches()) {
            String shortName = shortErrMatcher.group(1);
            Integer i = this.individualErrorCount.get(shortName);
            int occurrences = i == null ? 1 : i + 1;
            this.individualErrorCount.put(shortName, occurrences);
            return this.enforceErrorLimit(occurrences, this.all.toString(), this.savelinenum, this.fileName);
        }
        return this.enforceErrorLimit(1, this.all.toString(), this.lineNumber, this.fileName);
    }

    private void setInstanceVariablesForSomeReason(CharSequence line) {
        this.saveFlag = true;
        this.tmpErrFlag = true;
        if (this.checkExpectedStrs(line, this.expectedExceptions)) {
            this.saveFlag = false;
            this.tmpErrFlag = false;
            this.tmpErrLines = 0;
        }
        if (this.tmpErrFlag) {
            this.tmpErrLines = 1;
            this.all = new StringBuilder(line);
            this.all.append("\n");
            this.savelinenum = this.lineNumber;
        }
    }

    private String getShortName(CharSequence line) {
        Matcher m2 = exceptionPattern2.matcher(line);
        if (m2.find()) {
            return m2.group(1);
        }
        Matcher m3 = exceptionPattern3.matcher(line);
        if (m3.find()) {
            return m3.group(1);
        }
        Matcher m4 = exceptionPattern4.matcher(line);
        if (m4.find()) {
            return m4.group(1);
        }
        return null;
    }

    private boolean skipThisLogMsg(CharSequence line) {
        if (this.infoMsgFlag) {
            if (logPattern.matcher(line).find()) {
                this.infoMsgFlag = false;
            } else {
                if (blankPattern.matcher(line).matches()) {
                    this.infoMsgFlag = false;
                    return true;
                }
                return true;
            }
        }
        if (skipLevelPattern.matcher(line).find()) {
            this.infoMsgFlag = true;
            return true;
        }
        return false;
    }

    private void expectedExceptionMatcherHandler(Matcher expectedExceptionMatcher) {
        if (expectedExceptionMatcher.group(1).equals("add")) {
            this.expectedExceptions.add(Pattern.compile(expectedExceptionMatcher.group(2)));
        } else {
            this.expectedExceptions.remove(Pattern.compile(expectedExceptionMatcher.group(2)));
        }
    }

    public StringBuilder close() {
        if (this.saveFlag) {
            this.saveFlag = false;
            return this.enforceErrorLimit(1, this.all.toString(), this.savelinenum, this.fileName);
        }
        return null;
    }

    private boolean checkExpectedStrs(CharSequence line, List<Pattern> expectedExceptions) {
        return expectedExceptions.stream().anyMatch(expected -> expected.matcher(line).find()) || this.testExpectStrs.stream().anyMatch(testExpected -> testExpected.matcher(line).find());
    }

    private StringBuilder enforceErrorLimit(int hits, String line, int linenum, String filename) {
        if (hits < this.repeatLimit) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("-----------------------------------------------------------------------\n").append("Found suspect string in ").append(filename).append(" at line ").append(linenum).append("\n\n").append(line).append("\n");
            return buffer;
        }
        if (hits == this.repeatLimit) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("\n\nHit occurrence limit of ").append(hits).append(" for this string.\n").append("Further reporting of this type of error will be suppressed.\n");
            return buffer;
        }
        return null;
    }
}

