/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.internal;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.TimeUnit;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.test.dunit.internal.ChildVM;
import org.apache.geode.test.dunit.internal.MethodInvoker;
import org.apache.geode.test.dunit.internal.MethodInvokerResult;
import org.apache.geode.test.dunit.internal.RemoteDUnitVMIF;
import org.apache.logging.log4j.Logger;

class RemoteDUnitVM
extends UnicastRemoteObject
implements RemoteDUnitVMIF {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 251934856609958734L;

    RemoteDUnitVM() throws RemoteException {
    }

    @Override
    public MethodInvokerResult executeMethodOnObject(Object target, String methodName) {
        String name = target.getClass().getName() + '.' + methodName + " on object: " + target;
        long start = this.start(name);
        MethodInvokerResult result = MethodInvoker.executeObject(target, methodName);
        this.logDelta(name, start, result);
        return result;
    }

    protected long start(String name) {
        logger.info("Received method: {}", (Object)name);
        return System.nanoTime();
    }

    private void logDelta(String name, long start, MethodInvokerResult result) {
        long delta = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        logger.info("Got result: {} from {} (took {} ms)", (Object)result, (Object)name, (Object)delta);
    }

    @Override
    public MethodInvokerResult executeMethodOnObject(Object target, String methodName, Object[] args) {
        String name = target.getClass().getName() + '.' + methodName + (args != null ? " with " + args.length + " args" : "") + " on object: " + target;
        long start = this.start(name);
        MethodInvokerResult result = MethodInvoker.executeObject(target, methodName, args);
        this.logDelta(name, start, result);
        return result;
    }

    public MethodInvokerResult executeMethodOnClass(String className, String methodName) {
        String name = className + '.' + methodName;
        long start = this.start(name);
        MethodInvokerResult result = MethodInvoker.execute(className, methodName);
        this.logDelta(name, start, result);
        return result;
    }

    @Override
    public MethodInvokerResult executeMethodOnClass(String className, String methodName, Object[] args) {
        String name = className + '.' + methodName + (args != null ? " with " + args.length + " args" : "");
        long start = this.start(name);
        MethodInvokerResult result = MethodInvoker.execute(className, methodName, args);
        this.logDelta(name, start, result);
        return result;
    }

    public void executeTask(int tsid, int type, int index) throws RemoteException {
        throw new UnsupportedOperationException("executeTask is not implemented");
    }

    public void runShutdownHook() throws RemoteException {
        throw new UnsupportedOperationException("runShutdownHook is not implemented");
    }

    public void notifyDynamicActionComplete(int actionId) throws RemoteException {
        throw new UnsupportedOperationException("notifyDynamicActionComplete is not implemented");
    }

    @Override
    public void shutDownVM() throws RemoteException {
        ChildVM.stopVM();
    }

    public void disconnectVM() throws RemoteException {
        throw new UnsupportedOperationException("disconnectVM is not implemented");
    }
}

