/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.dunit.rules.MemberVM;
import org.apache.geode.test.junit.rules.GfshCommandRule;
import org.apache.geode.test.junit.rules.LocatorStarterRule;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class RebalanceCommandDistributedTestBase {
    @ClassRule
    public static ClusterStartupRule cluster = new ClusterStartupRule();
    @ClassRule
    public static GfshCommandRule gfsh = new GfshCommandRule();
    protected static MemberVM locator;
    protected static MemberVM server1;
    protected static MemberVM server2;

    @BeforeClass
    public static void beforeClass() {
        locator = cluster.startLocatorVM(0, l -> (LocatorStarterRule)l.withHttpService());
        int locatorPort = locator.getPort();
        server1 = cluster.startServerVM(1, "localhost", locatorPort);
        server2 = cluster.startServerVM(2, "localhost", locatorPort);
        RebalanceCommandDistributedTestBase.setUpRegions();
    }

    @Before
    public void before() throws Exception {
        gfsh.connect(locator.getJmxPort(), GfshCommandRule.PortType.jmxManager, new String[0]);
    }

    @Test
    public void testSimulateForEntireDSWithTimeout() {
        locator.waitUntilRegionIsReadyOnExactlyThisManyServers("/region-1", 2);
        locator.waitUntilRegionIsReadyOnExactlyThisManyServers("/region-2", 1);
        locator.waitUntilRegionIsReadyOnExactlyThisManyServers("/region-3", 1);
        String command = "rebalance --simulate=true --time-out=-1";
        gfsh.executeAndAssertThat(command).statusIsSuccess();
    }

    private static void setUpRegions() {
        server1.invoke(() -> {
            int i;
            InternalCache cache = ClusterStartupRule.getCache();
            RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
            Region region = dataRegionFactory.create("region-1");
            for (i = 0; i < 10; ++i) {
                region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
            }
            region = dataRegionFactory.create("region-2");
            for (i = 0; i < 100; ++i) {
                region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
            }
        });
        server2.invoke(() -> {
            int i;
            InternalCache cache = ClusterStartupRule.getCache();
            RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
            Region region = dataRegionFactory.create("region-1");
            for (i = 0; i < 100; ++i) {
                region.put((Object)("key" + (i + 400)), (Object)("value" + (i + 400)));
            }
            region = dataRegionFactory.create("region-3");
            for (i = 0; i < 10; ++i) {
                region.put((Object)("key" + (i + 200)), (Object)("value" + (i + 200)));
            }
        });
    }
}

