/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.query.Index;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.domain.Stock;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.test.junit.categories.GfshTest;
import org.apache.geode.test.junit.rules.GfshCommandRule;
import org.apache.geode.test.junit.rules.Server;
import org.apache.geode.test.junit.rules.ServerStarterRule;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={GfshTest.class})
public class IndexCommandsIntegrationTestBase {
    private static final String regionName = "regionA";
    private static final String groupName = "groupA";
    private static final String indexName = "indexA";
    @ClassRule
    public static ServerStarterRule server = (ServerStarterRule)((ServerStarterRule)((ServerStarterRule)((ServerStarterRule)new ServerStarterRule().withProperty("groups", "groupA")).withJMXManager()).withHttpService()).withAutoStart();
    @Rule
    public GfshCommandRule gfsh = new GfshCommandRule();

    @BeforeClass
    public static void beforeClass() throws Exception {
        InternalCache cache = server.getCache();
        Region<?, ?> region = IndexCommandsIntegrationTestBase.createPartitionedRegion(regionName, (Cache)cache, String.class, Stock.class);
        region.put((Object)"VMW", (Object)new Stock("VMW", 98.0));
        region.put((Object)"APPL", (Object)new Stock("APPL", 600.0));
    }

    @Before
    public void before() throws Exception {
        this.connect(server);
    }

    @After
    public void after() throws Exception {
        Collection indices = server.getCache().getQueryService().getIndexes();
        indices.stream().map(Index::getName).forEach(indexName -> this.gfsh.executeAndAssertThat("destroy index --name=" + indexName).statusIsSuccess());
        this.gfsh.executeAndAssertThat("list index").statusIsSuccess();
        Assertions.assertThat((String)this.gfsh.getGfshOutput()).contains(new CharSequence[]{"No Indexes Found"});
    }

    public void connect(Server server) throws Exception {
        this.gfsh.connectAndVerify(server.getJmxPort(), GfshCommandRule.PortType.jmxManager, new String[0]);
    }

    @Test
    public void testCreate() throws Exception {
        this.createSimpleIndexA();
    }

    @Test
    public void testCreateIndexWithMultipleIterators() throws Exception {
        CommandStringBuilder createStringBuilder = new CommandStringBuilder("create index");
        createStringBuilder.addOption("name", indexName);
        createStringBuilder.addOption("expression", "\"h.low\"");
        createStringBuilder.addOption("region", "\"/regionA s, s.history h\"");
        this.gfsh.executeAndAssertThat(createStringBuilder.toString()).statusIsSuccess();
        Assertions.assertThat((String)this.gfsh.getGfshOutput()).contains(new CharSequence[]{"Index successfully created"});
        this.gfsh.executeAndAssertThat("list index").statusIsSuccess();
        Assertions.assertThat((String)this.gfsh.getGfshOutput()).contains(new CharSequence[]{indexName});
    }

    @Test
    public void testListIndexValidField() throws Exception {
        CommandStringBuilder createStringBuilder = new CommandStringBuilder("create index");
        createStringBuilder.addOption("name", indexName);
        createStringBuilder.addOption("expression", "\"h.low\"");
        createStringBuilder.addOption("region", "\"/regionA s, s.history h\"");
        this.gfsh.executeAndAssertThat(createStringBuilder.toString()).statusIsSuccess();
        Assertions.assertThat((String)this.gfsh.getGfshOutput()).contains(new CharSequence[]{"Index successfully created"});
        this.gfsh.executeAndAssertThat("list index").statusIsSuccess();
        Assertions.assertThat((String)this.gfsh.getGfshOutput()).contains(new CharSequence[]{indexName});
    }

    @Test
    public void testCannotCreateIndexWithExistingIndexName() throws Exception {
        this.createSimpleIndexA();
        CommandStringBuilder csb = new CommandStringBuilder("create index");
        csb.addOption("name", indexName);
        csb.addOption("expression", "key");
        csb.addOption("region", "/regionA");
        csb.addOption("type", "hash");
        CommandResult result = this.gfsh.executeCommand(csb.toString());
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)Result.Status.ERROR);
    }

    @Test
    public void creatIndexWithNoBeginningSlash() throws Exception {
        CommandStringBuilder csb = new CommandStringBuilder("create index");
        csb.addOption("name", indexName);
        csb.addOption("expression", "key");
        csb.addOption("region", regionName);
        this.gfsh.executeAndAssertThat(csb.toString()).statusIsSuccess();
        Assertions.assertThat((String)this.gfsh.getGfshOutput()).contains(new CharSequence[]{"Index successfully created"});
        this.gfsh.executeAndAssertThat("list index").statusIsSuccess();
        Assertions.assertThat((String)this.gfsh.getGfshOutput()).contains(new CharSequence[]{indexName});
    }

    @Test
    public void testCannotCreateIndexInIncorrectRegion() throws Exception {
        CommandStringBuilder csb = new CommandStringBuilder("create index");
        csb.addOption("name", indexName);
        csb.addOption("expression", "key");
        csb.addOption("region", "/InvalidRegionName");
        csb.addOption("type", "hash");
        CommandResult result = this.gfsh.executeCommand(csb.toString());
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)Result.Status.ERROR);
        Assertions.assertThat((String)this.gfsh.getGfshOutput()).contains(new CharSequence[]{"Region not found : \"/InvalidRegionName\""});
    }

    @Test
    public void cannotCreateWithTheSameName() throws Exception {
        this.createSimpleIndexA();
        this.gfsh.executeAndAssertThat("create index --name=indexA --expression=key --region=/regionA").statusIsError().containsOutput(new String[]{"Index \"indexA\" already exists.  Create failed due to duplicate name"});
    }

    @Test
    public void testCannotCreateIndexWithInvalidIndexExpression() throws Exception {
        CommandStringBuilder csb = new CommandStringBuilder("create index");
        csb.addOption("name", indexName);
        csb.addOption("expression", "InvalidExpressionOption");
        csb.addOption("region", "/regionA");
        csb.addOption("type", "hash");
        CommandResult result = this.gfsh.executeCommand(csb.toString());
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)Result.Status.ERROR);
    }

    @Test
    public void testCannotDestroyIndexWithInvalidIndexName() throws Exception {
        CommandStringBuilder csb = new CommandStringBuilder("destroy index");
        csb.addOption("name", "IncorrectIndexName");
        CommandResult result = this.gfsh.executeCommand(csb.toString());
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)Result.Status.ERROR);
        Assertions.assertThat((String)this.gfsh.getGfshOutput()).contains(new CharSequence[]{CliStrings.format((String)"Index named \"{0}\" not found", (Object)"IncorrectIndexName")});
    }

    @Test
    public void testCannotDestroyIndexWithInvalidRegion() throws Exception {
        CommandStringBuilder csb = new CommandStringBuilder("destroy index");
        csb.addOption("name", indexName);
        csb.addOption("region", "IncorrectRegion");
        CommandResult result = this.gfsh.executeCommand(csb.toString());
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)Result.Status.ERROR);
        Assertions.assertThat((String)this.gfsh.getGfshOutput()).contains(new CharSequence[]{"ERROR", "Region \"IncorrectRegion\" not found"});
    }

    @Test
    public void testCannotDestroyIndexWithInvalidMember() throws Exception {
        CommandStringBuilder csb = new CommandStringBuilder("destroy index");
        csb.addOption("name", indexName);
        csb.addOption("region", "Region");
        csb.addOption("member", "InvalidMemberName");
        CommandResult result = this.gfsh.executeCommand(csb.toString());
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)Result.Status.ERROR);
        Assertions.assertThat((String)this.gfsh.getGfshOutput()).contains(new CharSequence[]{"No Members Found"});
    }

    @Test
    public void testCannotDestroyIndexWithNoOptions() throws Exception {
        CommandStringBuilder csb = new CommandStringBuilder("destroy index");
        CommandResult result = this.gfsh.executeCommand(csb.toString());
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)Result.Status.ERROR);
        Assertions.assertThat((String)this.gfsh.getGfshOutput()).contains(new CharSequence[]{"requires that one or more parameters be provided."});
    }

    @Test
    public void testDestroyIndexViaRegion() throws Exception {
        this.createSimpleIndexA();
        CommandStringBuilder csb = new CommandStringBuilder("destroy index");
        csb.addOption("region", regionName);
        this.gfsh.executeAndAssertThat(csb.toString()).statusIsSuccess().containsOutput(new String[]{"Destroyed all indexes on region regionA"});
    }

    @Test
    public void testDestroyIndexViaGroup() throws Exception {
        this.createSimpleIndexA();
        CommandStringBuilder csb = new CommandStringBuilder("destroy index");
        csb.addOption("group", groupName);
        this.gfsh.executeAndAssertThat(csb.toString()).statusIsSuccess().containsOutput(new String[]{"Destroyed all indexes"});
    }

    @Test
    public void testFailWhenDestroyIndexIsNotIdempotent() throws Exception {
        this.createSimpleIndexA();
        CommandStringBuilder csb = new CommandStringBuilder("destroy index");
        csb.addOption("name", indexName);
        csb.addOption("if-exists", "false");
        this.gfsh.executeAndAssertThat(csb.toString()).statusIsSuccess().containsOutput(new String[]{"Destroyed index indexA"});
        this.gfsh.executeAndAssertThat(csb.toString()).statusIsError().containsOutput(new String[]{"Index named \"indexA\" not found"});
    }

    @Test
    public void testDestroyIndexOnRegionIsIdempotent() throws Exception {
        this.createSimpleIndexA();
        CommandStringBuilder csb = new CommandStringBuilder("destroy index");
        csb.addOption("region", regionName);
        csb.addOption("if-exists", "true");
        this.gfsh.executeAndAssertThat(csb.toString()).statusIsSuccess().containsOutput(new String[]{"Destroyed all indexes on region regionA"});
        this.gfsh.executeAndAssertThat(csb.toString()).statusIsSuccess().containsOutput(new String[]{"Destroyed all indexes on region regionA"});
    }

    @Test
    public void testDestroyIndexByNameIsIdempotent() throws Exception {
        this.createSimpleIndexA();
        CommandStringBuilder csb = new CommandStringBuilder("destroy index");
        csb.addOption("name", indexName);
        csb.addOption("if-exists");
        this.gfsh.executeAndAssertThat(csb.toString()).statusIsSuccess().containsOutput(new String[]{"Destroyed index indexA"});
        CommandResult result = this.gfsh.executeCommand(csb.toString());
        Assertions.assertThat((Comparable)result.getStatus()).isEqualTo((Object)Result.Status.OK);
        Map table = result.getMapFromTableContent("member-status");
        Assertions.assertThat((List)((List)table.get("Status"))).containsExactly((Object[])new String[]{"IGNORED"});
        Assertions.assertThat((List)((List)table.get("Message"))).containsExactly((Object[])new String[]{"Index named \"indexA\" not found"});
    }

    private void createSimpleIndexA() throws Exception {
        CommandStringBuilder csb = new CommandStringBuilder("create index");
        csb.addOption("name", indexName);
        csb.addOption("expression", "key");
        csb.addOption("region", "/regionA");
        this.gfsh.executeAndAssertThat(csb.toString()).statusIsSuccess().containsOutput(new String[]{"Index successfully created"});
    }

    private static Region<?, ?> createPartitionedRegion(String regionName, Cache cache, Class keyConstraint, Class valueConstraint) {
        RegionFactory regionFactory = cache.createRegionFactory();
        regionFactory.setDataPolicy(DataPolicy.PARTITION);
        regionFactory.setKeyConstraint(keyConstraint);
        regionFactory.setValueConstraint(valueConstraint);
        return regionFactory.create(regionName);
    }
}

