/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.geode.test.dunit.AsyncInvocation;
import org.apache.geode.test.dunit.SerializableCallableIF;
import org.apache.geode.test.dunit.SerializableRunnableIF;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.junit.rules.MemberStarterRule;

public abstract class VMProvider {
    public static void invokeInEveryMember(SerializableRunnableIF runnableIF, VMProvider ... members) {
        Arrays.stream(members).forEach(member -> member.invoke(runnableIF));
    }

    public abstract VM getVM();

    public void stop() {
        this.stop(true);
    }

    public void stop(boolean cleanWorkingDir) {
        this.getVM().invoke(() -> {
            ClusterStartupRule.stopElementInsideVM();
            MemberStarterRule.disconnectDSIfAny();
        });
        if (cleanWorkingDir) {
            Arrays.stream(this.getWorkingDir().listFiles()).forEach(FileUtils::deleteQuietly);
        }
    }

    public boolean isClient() {
        return (Boolean)this.getVM().invoke(() -> ClusterStartupRule.clientCacheRule != null);
    }

    public boolean isLocator() {
        return (Boolean)this.getVM().invoke(() -> ClusterStartupRule.getLocator() != null);
    }

    public boolean isServer() {
        return (Boolean)this.getVM().invoke(() -> ClusterStartupRule.getServer() != null);
    }

    public void invoke(SerializableRunnableIF runnable) {
        this.getVM().invoke(runnable);
    }

    public <T> T invoke(SerializableCallableIF<T> callable) {
        return this.getVM().invoke(callable);
    }

    public void invoke(String name, SerializableRunnableIF runnable) {
        this.getVM().invoke(name, runnable);
    }

    public <T> T invoke(String name, SerializableCallableIF<T> callable) {
        return this.getVM().invoke(name, callable);
    }

    public AsyncInvocation invokeAsync(SerializableRunnableIF runnable) {
        return this.getVM().invokeAsync(runnable);
    }

    public AsyncInvocation invokeAsync(String name, SerializableRunnableIF runnable) {
        return this.getVM().invokeAsync(name, runnable);
    }

    public File getWorkingDir() {
        return this.getVM().getWorkingDirectory();
    }
}

