/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.test.dunit.SerializableCallableIF;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.dunit.rules.MemberVM;
import org.apache.geode.test.junit.rules.GfshCommandRule;
import org.apache.geode.test.junit.rules.LocatorStarterRule;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ShutdownCommandDUnitTestBase {
    private MemberVM locator;
    private MemberVM server1;
    private MemberVM server2;
    @Rule
    public ClusterStartupRule clusterStartupRule = new ClusterStartupRule();
    @Rule
    public GfshCommandRule gfsh = new GfshCommandRule();

    @Before
    public void setup() throws Exception {
        this.locator = this.clusterStartupRule.startLocatorVM(0, l -> (LocatorStarterRule)l.withHttpService());
        this.server1 = this.clusterStartupRule.startServerVM(1, this.locator.getPort());
        this.server2 = this.clusterStartupRule.startServerVM(2, this.locator.getPort());
        this.connect(this.locator);
    }

    void connect(MemberVM locator) throws Exception {
        this.gfsh.connectAndVerify(locator, new String[0]);
    }

    @Test
    public void testShutdownServers() {
        String command = "shutdown";
        this.gfsh.executeAndAssertThat(command).statusIsSuccess().containsOutput(new String[]{"Shutdown is triggered"});
        this.verifyShutDown(this.server1, this.server2);
        this.gfsh.executeAndAssertThat("list members").statusIsSuccess();
        Assertions.assertThat((String)this.gfsh.getGfshOutput()).contains(new CharSequence[]{"locator-0"});
    }

    @Test
    public void testShutdownAll() {
        String command = "shutdown --include-locators=true";
        this.gfsh.executeAndAssertThat(command).statusIsSuccess().containsOutput(new String[]{"Shutdown is triggered"});
        this.verifyShutDown(this.server1, this.server2, this.locator);
    }

    private void verifyShutDown(MemberVM ... members) {
        SerializableCallableIF isCacheOpenInThisVM = () -> {
            boolean cacheExists;
            try {
                Cache cacheInstance = CacheFactory.getAnyInstance();
                cacheExists = cacheInstance.getDistributedSystem().isConnected();
            }
            catch (CacheClosedException e) {
                cacheExists = false;
            }
            return cacheExists;
        };
        for (MemberVM member : members) {
            Callable<Boolean> isMemberShutDown = () -> (Boolean)member.getVM().invoke(isCacheOpenInThisVM) == false;
            Awaitility.await().atMost(2L, TimeUnit.MINUTES).until(isMemberShutDown);
        }
    }
}

