/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.dunit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.query.CqAttributesFactory;
import org.apache.geode.cache.query.CqEvent;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.CqExistsException;
import org.apache.geode.cache.query.CqListener;
import org.apache.geode.cache.query.CqQuery;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.security.ExpirableSecurityManager;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.dunit.rules.MemberVM;

public class SecurityTestUtils {
    public static ExpirableSecurityManager collectSecurityManagers(MemberVM ... vms) {
        ArrayList results = new ArrayList();
        for (MemberVM vm : vms) {
            results.add(vm.invoke(SecurityTestUtils::getSecurityManager));
        }
        ExpirableSecurityManager consolidated = new ExpirableSecurityManager();
        for (ExpirableSecurityManager result : results) {
            consolidated.getExpiredUsers().addAll(result.getExpiredUsers());
            SecurityTestUtils.combine(consolidated.getAuthorizedOps(), result.getAuthorizedOps());
            SecurityTestUtils.combine(consolidated.getUnAuthorizedOps(), result.getUnAuthorizedOps());
        }
        return consolidated;
    }

    public static void combine(Map<String, List<String>> to, Map<String, List<String>> from) {
        for (String key : from.keySet()) {
            if (to.containsKey(key)) {
                to.get(key).addAll((Collection<String>)from.get(key));
                continue;
            }
            to.put(key, from.get(key));
        }
    }

    public static ExpirableSecurityManager getSecurityManager() {
        return (ExpirableSecurityManager)Objects.requireNonNull(ClusterStartupRule.getCache()).getSecurityService().getSecurityManager();
    }

    public static EventsCqListner createAndExecuteCQ(QueryService queryService, String cqName, String query) throws CqExistsException, CqException, RegionNotFoundException {
        CqAttributesFactory cqaf = new CqAttributesFactory();
        EventsCqListner listenter = new EventsCqListner();
        cqaf.addCqListener((CqListener)listenter);
        CqQuery cq = queryService.newCq(cqName, query, cqaf.create());
        cq.execute();
        return listenter;
    }

    public static class KeysCacheListener
    extends CacheListenerAdapter<Object, Object> {
        public List<String> keys = new CopyOnWriteArrayList<String>();

        public void afterCreate(EntryEvent event) {
            this.keys.add((String)event.getKey());
        }
    }

    public static class EventsCqListner
    implements CqListener {
        private final List<String> keys = new ArrayList<String>();

        public void onEvent(CqEvent aCqEvent) {
            this.keys.add(aCqEvent.getKey().toString());
        }

        public void onError(CqEvent aCqEvent) {
        }

        public List<String> getKeys() {
            return this.keys;
        }
    }
}

