/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.rules.AbstractDistributedRule;
import org.apache.geode.util.internal.CompletionUtils;
import org.apache.geode.util.internal.UncheckedUtils;

public class DistributedReference<V>
extends AbstractDistributedRule {
    private static final AtomicReference<Map<Integer, Object>> REFERENCE = new AtomicReference();
    private final AtomicBoolean autoClose = new AtomicBoolean(true);
    private final int identity = this.hashCode();

    public DistributedReference() {
        this(VM.DEFAULT_VM_COUNT);
    }

    public DistributedReference(int vmCount) {
        super(vmCount);
    }

    public DistributedReference<V> autoClose(boolean value) {
        this.autoClose.set(value);
        return this;
    }

    public V get() {
        return (V)UncheckedUtils.uncheckedCast((Object)REFERENCE.get().get(this.identity));
    }

    public DistributedReference<V> set(V newValue) {
        REFERENCE.get().put(this.identity, newValue);
        return this;
    }

    @Override
    protected void before() {
        this.invoker().invokeInEveryVMAndController(() -> this.invokeBefore());
    }

    @Override
    protected void after() {
        this.invoker().invokeInEveryVMAndController(() -> this.invokeAfter());
    }

    @Override
    protected void afterCreateVM(VM vm) {
        vm.invoke(() -> this.invokeBefore());
    }

    @Override
    protected void beforeBounceVM(VM vm) {
    }

    @Override
    protected void afterBounceVM(VM vm) {
        vm.invoke(() -> this.invokeBefore());
    }

    private void invokeBefore() {
        REFERENCE.compareAndSet(null, new HashMap());
        REFERENCE.get().putIfAbsent(this.identity, null);
    }

    private void invokeAfter() {
        Map references = REFERENCE.getAndSet(null);
        if (references == null) {
            return;
        }
        for (Object object : references.values()) {
            this.invokeAfter(object);
        }
    }

    private void invokeAfter(Object object) {
        if (object == null) {
            return;
        }
        if (this.autoClose.get()) {
            this.autoClose(object);
        }
    }

    private void autoClose(Object object) {
        if (object instanceof AutoCloseable) {
            CompletionUtils.close((AutoCloseable)((AutoCloseable)object));
        } else if (object instanceof AtomicBoolean) {
            CompletionUtils.close((AtomicBoolean)((AtomicBoolean)object));
        } else if (object instanceof CountDownLatch) {
            CompletionUtils.close((CountDownLatch)((CountDownLatch)object));
        } else if (DistributedReference.hasMethod(object.getClass(), "close")) {
            DistributedReference.invokeMethod(object, "close");
        } else if (DistributedReference.hasMethod(object.getClass(), "disconnect")) {
            DistributedReference.invokeMethod(object, "disconnect");
        } else if (DistributedReference.hasMethod(object.getClass(), "stop")) {
            DistributedReference.invokeMethod(object, "stop");
        }
    }

    private static boolean hasMethod(Class<?> objectClass, String methodName) {
        try {
            Method method = objectClass.getMethod(methodName, new Class[0]);
            Class<?> returnType = method.getReturnType();
            if (method.getParameterCount() == 0 && Modifier.isPublic(method.getModifiers())) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    private static void invokeMethod(Object object, String methodName) {
        try {
            Method method = object.getClass().getMethod(methodName, new Class[0]);
            method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

