/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.rules.AbstractDistributedRule;
import org.apache.geode.test.junit.rules.ExecutorServiceRule;

public class DistributedExecutorServiceRule
extends AbstractDistributedRule {
    private static final AtomicReference<ExecutorServiceRule> delegate = new AtomicReference();
    private final boolean enableAwaitTermination;
    private final long awaitTerminationTimeout;
    private final TimeUnit awaitTerminationTimeUnit;
    private final boolean awaitTerminationBeforeShutdown;
    private final boolean useShutdown;
    private final boolean useShutdownNow;
    private final int threadCount;

    public static Builder builder() {
        return new Builder();
    }

    public DistributedExecutorServiceRule() {
        this(new Builder().threadCount(0).vmCount(VM.DEFAULT_VM_COUNT));
    }

    public DistributedExecutorServiceRule(int threadCount, int vmCount) {
        this(new Builder().threadCount(threadCount).vmCount(vmCount));
    }

    private DistributedExecutorServiceRule(Builder builder) {
        this(builder.enableAwaitTermination, builder.awaitTerminationTimeout, builder.awaitTerminationTimeUnit, builder.awaitTerminationBeforeShutdown, builder.useShutdown, builder.useShutdownNow, builder.threadCount, builder.vmCount);
    }

    private DistributedExecutorServiceRule(boolean enableAwaitTermination, long awaitTerminationTimeout, TimeUnit awaitTerminationTimeUnit, boolean awaitTerminationBeforeShutdown, boolean useShutdown, boolean useShutdownNow, int threadCount, int vmCount) {
        super(vmCount);
        this.enableAwaitTermination = enableAwaitTermination;
        this.awaitTerminationTimeout = awaitTerminationTimeout;
        this.awaitTerminationTimeUnit = awaitTerminationTimeUnit;
        this.awaitTerminationBeforeShutdown = awaitTerminationBeforeShutdown;
        this.useShutdown = useShutdown;
        this.useShutdownNow = useShutdownNow;
        this.threadCount = threadCount;
    }

    public ExecutorService getExecutorService() {
        return delegate.get().getExecutorService();
    }

    public void execute(ExecutorServiceRule.ThrowingRunnable command) {
        delegate.get().execute(command);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return delegate.get().submit(task);
    }

    public <T> Future<T> submit(ExecutorServiceRule.ThrowingRunnable task, T result) {
        return delegate.get().submit(task, result);
    }

    public Future<Void> submit(ExecutorServiceRule.ThrowingRunnable task) {
        return delegate.get().submit(task);
    }

    public CompletableFuture<Void> runAsync(Runnable runnable) {
        return delegate.get().runAsync(runnable);
    }

    public <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        return delegate.get().supplyAsync(supplier);
    }

    public Set<Thread> getThreads() {
        return delegate.get().getThreads();
    }

    public long[] getThreadIds() {
        return delegate.get().getThreadIds();
    }

    public String dumpThreads() {
        return delegate.get().dumpThreads();
    }

    @Override
    public void before() throws Exception {
        this.invoker().invokeInEveryVMAndController(() -> this.invokeBefore());
    }

    @Override
    public void after() {
        this.invoker().invokeInEveryVMAndController(() -> this.invokeAfter());
    }

    @Override
    protected void afterCreateVM(VM vm) {
        vm.invoke(() -> this.invokeBefore());
    }

    @Override
    protected void afterBounceVM(VM vm) {
        vm.invoke(() -> this.invokeBefore());
    }

    private void invokeBefore() throws Exception {
        try {
            delegate.set(new ExecutorServiceRule(this.enableAwaitTermination, this.awaitTerminationTimeout, this.awaitTerminationTimeUnit, this.awaitTerminationBeforeShutdown, this.useShutdown, this.useShutdownNow, this.threadCount));
            delegate.get().before();
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    private void invokeAfter() {
        delegate.get().after();
    }

    public static class Builder {
        private boolean enableAwaitTermination;
        private long awaitTerminationTimeout;
        private TimeUnit awaitTerminationTimeUnit = TimeUnit.NANOSECONDS;
        private boolean awaitTerminationBeforeShutdown = true;
        private boolean useShutdown;
        private boolean useShutdownNow = true;
        private int threadCount;
        private int vmCount;

        protected Builder() {
        }

        public Builder awaitTermination(long timeout, TimeUnit unit) {
            this.enableAwaitTermination = true;
            this.awaitTerminationTimeout = timeout;
            this.awaitTerminationTimeUnit = unit;
            return this;
        }

        public Builder useShutdown() {
            this.useShutdown = true;
            this.useShutdownNow = false;
            return this;
        }

        public Builder useShutdownNow() {
            this.useShutdown = false;
            this.useShutdownNow = true;
            return this;
        }

        public Builder awaitTerminationBeforeShutdown() {
            this.awaitTerminationBeforeShutdown = true;
            return this;
        }

        public Builder awaitTerminationAfterShutdown() {
            this.awaitTerminationBeforeShutdown = false;
            return this;
        }

        public Builder threadCount(int threadCount) {
            this.threadCount = threadCount;
            return this;
        }

        public Builder vmCount(int vmCount) {
            this.vmCount = vmCount;
            return this;
        }

        public DistributedExecutorServiceRule build() {
            return new DistributedExecutorServiceRule(this);
        }
    }
}

