/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.test.dunit.Host;
import org.apache.geode.test.dunit.IgnoredException;
import org.apache.geode.test.dunit.SerializableConsumerIF;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.internal.DUnitLauncher;
import org.apache.geode.test.dunit.rules.ClientVM;
import org.apache.geode.test.dunit.rules.DistributedRestoreSystemProperties;
import org.apache.geode.test.dunit.rules.MemberVM;
import org.apache.geode.test.dunit.rules.SerializableFunction;
import org.apache.geode.test.junit.rules.ClientCacheRule;
import org.apache.geode.test.junit.rules.Locator;
import org.apache.geode.test.junit.rules.LocatorStarterRule;
import org.apache.geode.test.junit.rules.MemberStarterRule;
import org.apache.geode.test.junit.rules.Server;
import org.apache.geode.test.junit.rules.ServerStarterRule;
import org.apache.geode.test.junit.rules.VMProvider;
import org.apache.geode.test.junit.rules.serializable.SerializableTestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ClusterStartupRule
implements SerializableTestRule {
    public static MemberStarterRule<?> memberStarter;
    public static ClientCacheRule clientCacheRule;
    private boolean skipLocalDistributedSystemCleanup;
    private final int vmCount;
    private final DistributedRestoreSystemProperties restoreSystemProperties = new DistributedRestoreSystemProperties();
    private Map<Integer, VMProvider> occupiedVMs;
    private boolean logFile = false;

    public static InternalCache getCache() {
        if (memberStarter == null) {
            return null;
        }
        return memberStarter.getCache();
    }

    public static InternalLocator getLocator() {
        if (!(memberStarter instanceof LocatorStarterRule)) {
            return null;
        }
        return ((LocatorStarterRule)memberStarter).getLocator();
    }

    public static CacheServer getServer() {
        if (!(memberStarter instanceof ServerStarterRule)) {
            return null;
        }
        return ((ServerStarterRule)memberStarter).getServer();
    }

    public ClusterStartupRule() {
        this(DUnitLauncher.NUM_VMS);
    }

    public ClusterStartupRule(int vmCount) {
        this.vmCount = vmCount;
    }

    public static ClientCache getClientCache() {
        if (clientCacheRule == null) {
            return null;
        }
        return clientCacheRule.getCache();
    }

    public ClusterStartupRule withLogFile() {
        this.logFile = true;
        return this;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ClusterStartupRule.this.before(description);
                try {
                    base.evaluate();
                }
                finally {
                    ClusterStartupRule.this.after(description);
                }
            }
        };
    }

    private void before(Description description) throws Throwable {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11)) {
            IgnoredException.addIgnoredException("committed = 538968064 should be < max = 536870912");
        }
        DUnitLauncher.launchIfNeeded(false);
        for (int i = 0; i < this.vmCount; ++i) {
            Host.getHost(0).getVM(i);
        }
        this.restoreSystemProperties.beforeDistributedTest(description);
        this.occupiedVMs = new HashMap<Integer, VMProvider>();
    }

    private void after(Description description) throws Throwable {
        if (!this.skipLocalDistributedSystemCleanup) {
            MemberStarterRule.disconnectDSIfAny();
        }
        ArrayList vms = new ArrayList();
        vms.addAll(this.occupiedVMs.values().stream().filter(x -> x.isClient()).collect(Collectors.toSet()));
        vms.addAll(this.occupiedVMs.values().stream().filter(x -> x.isServer()).collect(Collectors.toSet()));
        vms.addAll(this.occupiedVMs.values().stream().filter(x -> x.isLocator()).collect(Collectors.toSet()));
        vms.forEach(x -> x.stop());
        Arrays.stream(this.getWorkingDirRoot().listFiles()).filter(File::isFile).forEach(FileUtils::deleteQuietly);
        this.restoreSystemProperties.afterDistributedTest(description);
        IgnoredException.removeAllExpectedExceptions();
        DUnitLauncher.closeAndCheckForSuspects();
    }

    public void setSkipLocalDistributedSystemCleanup(boolean skipLocalDistributedSystemCleanup) {
        this.skipLocalDistributedSystemCleanup = skipLocalDistributedSystemCleanup;
    }

    public MemberVM startLocatorVM(int index, int ... locatorPort) {
        return this.startLocatorVM(index, x -> (LocatorStarterRule)x.withConnectionToLocator(locatorPort));
    }

    public MemberVM startLocatorVM(int index, Properties properties, int ... locatorPort) {
        return this.startLocatorVM(index, x -> (LocatorStarterRule)((LocatorStarterRule)x.withProperties(properties)).withConnectionToLocator(locatorPort));
    }

    public MemberVM startLocatorVM(int index, int port, Properties properties, int ... locatorPort) {
        return this.startLocatorVM(index, port, "10240.0.0", x -> (LocatorStarterRule)((LocatorStarterRule)x.withProperties(properties)).withConnectionToLocator(locatorPort));
    }

    public MemberVM startLocatorVM(int index, String version) {
        return this.startLocatorVM(index, 0, version, x -> x);
    }

    public MemberVM startLocatorVM(int index, SerializableFunction<LocatorStarterRule> ruleOperator) {
        return this.startLocatorVM(index, 0, "10240.0.0", ruleOperator);
    }

    public MemberVM startLocatorVM(int index, int port, String version, SerializableFunction<LocatorStarterRule> ruleOperator) {
        String defaultName = "locator-" + index;
        VM locatorVM = this.getVM(index, version);
        Locator server = (Locator)locatorVM.invoke("start locator in vm" + index, () -> {
            memberStarter = new LocatorStarterRule();
            LocatorStarterRule locatorStarter = (LocatorStarterRule)memberStarter;
            if (this.logFile) {
                locatorStarter.withLogFile();
            }
            ruleOperator.apply(locatorStarter);
            locatorStarter.withName(defaultName);
            locatorStarter.withAutoStart();
            if (port != 0) {
                locatorStarter.withPort(port);
            }
            locatorStarter.before();
            return locatorStarter;
        });
        MemberVM memberVM = new MemberVM(server, locatorVM);
        this.occupiedVMs.put(index, memberVM);
        return memberVM;
    }

    public MemberVM startServerVM(int index, int ... locatorPort) {
        return this.startServerVM(index, x -> (ServerStarterRule)x.withConnectionToLocator(locatorPort));
    }

    public MemberVM startServerVM(int index, String group, int ... locatorPort) {
        return this.startServerVM(index, x -> (ServerStarterRule)((ServerStarterRule)x.withConnectionToLocator(locatorPort)).withProperty("groups", group));
    }

    public MemberVM startServerVM(int index, Properties properties, int ... locatorPort) {
        return this.startServerVM(index, x -> (ServerStarterRule)((ServerStarterRule)x.withProperties(properties)).withConnectionToLocator(locatorPort));
    }

    public MemberVM startServerVM(int index, SerializableFunction<ServerStarterRule> ruleOperator) {
        return this.startServerVM(index, "10240.0.0", ruleOperator);
    }

    public MemberVM startServerVM(int index, String version, SerializableFunction<ServerStarterRule> ruleOperator) {
        String defaultName = "server-" + index;
        VM serverVM = this.getVM(index, version);
        Server server = (Server)serverVM.invoke("startServerVM", () -> {
            memberStarter = new ServerStarterRule();
            ServerStarterRule serverStarter = (ServerStarterRule)memberStarter;
            if (this.logFile) {
                serverStarter.withLogFile();
            }
            ruleOperator.apply(serverStarter);
            serverStarter.withName(defaultName);
            serverStarter.withAutoStart();
            serverStarter.before();
            return serverStarter;
        });
        MemberVM memberVM = new MemberVM(server, serverVM);
        this.occupiedVMs.put(index, memberVM);
        return memberVM;
    }

    public ClientVM startClientVM(int index, String clientVersion, SerializableConsumerIF<ClientCacheRule> clientCacheRuleSetUp) throws Exception {
        VM client = this.getVM(index, clientVersion);
        Exception error = (Exception)client.invoke(() -> {
            clientCacheRule = new ClientCacheRule();
            try {
                clientCacheRuleSetUp.accept(clientCacheRule);
                clientCacheRule.createCache();
                return null;
            }
            catch (Exception e) {
                return e;
            }
        });
        if (error != null) {
            throw error;
        }
        ClientVM clientVM = new ClientVM(client);
        this.occupiedVMs.put(index, clientVM);
        return clientVM;
    }

    public ClientVM startClientVM(int index, SerializableConsumerIF<ClientCacheRule> clientCacheRuleSetUp) throws Exception {
        return this.startClientVM(index, "10240.0.0", clientCacheRuleSetUp);
    }

    public ClientVM startClientVM(int index, String clientVersion, Properties properties, SerializableConsumerIF<ClientCacheFactory> cacheFactorySetup) throws Exception {
        return this.startClientVM(index, clientVersion, c -> c.withProperties(properties).withCacheSetup(cacheFactorySetup));
    }

    public ClientVM startClientVM(int index, Properties properties, SerializableConsumerIF<ClientCacheFactory> cacheFactorySetup) throws Exception {
        return this.startClientVM(index, c -> c.withProperties(properties).withCacheSetup(cacheFactorySetup));
    }

    public MemberVM getMember(int index) {
        return (MemberVM)this.occupiedVMs.get(index);
    }

    public VM getVM(int index, String version) {
        return Host.getHost(0).getVM(version, index);
    }

    public VM getVM(int index) {
        return Host.getHost(0).getVM(index);
    }

    public void stop(int index) {
        this.stop(index, true);
    }

    public void stop(int index, boolean cleanWorkingDir) {
        DUnitLauncher.closeAndCheckForSuspects(index);
        this.occupiedVMs.get(index).stop(cleanWorkingDir);
    }

    public void crashVM(int index) {
        VMProvider member = this.occupiedVMs.get(index);
        member.getVM().bounceForcibly();
    }

    public File getWorkingDirRoot() {
        return new File("dunit");
    }

    public static void stopElementInsideVM() {
        if (memberStarter != null) {
            memberStarter.setCleanWorkingDir(false);
            memberStarter.after();
            memberStarter = null;
        }
        if (clientCacheRule != null) {
            clientCacheRule.after();
            clientCacheRule = null;
        }
    }
}

