/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.functions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CancellationException;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.control.RebalanceFactory;
import org.apache.geode.cache.control.RebalanceOperation;
import org.apache.geode.cache.control.ResourceManager;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.MyFunctionExecutionException;
import org.apache.geode.internal.cache.execute.RegionFunctionContextImpl;
import org.apache.geode.internal.cache.xmlcache.Declarable2;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class TestFunction<T>
implements Function<T>,
Declarable2,
DataSerializable {
    public static final String TEST_FUNCTION10 = "TestFunction10";
    public static final String TEST_FUNCTION9 = "TestFunction9";
    public static final String TEST_FUNCTION8 = "TestFunction8";
    public static final String TEST_FUNCTION6 = "TestFunction6";
    public static final String TEST_FUNCTION5 = "TestFunction5";
    public static final String TEST_FUNCTION7 = "TestFunction7";
    public static final String TEST_FUNCTION4 = "TestFunction4";
    public static final String TEST_FUNCTION3 = "TestFunction3";
    public static final String TEST_FUNCTION2 = "TestFunction2";
    public static final String TEST_FUNCTION1 = "TestFunction1";
    public static final String TEST_FUNCTION_EXCEPTION = "TestFunctionException";
    public static final String TEST_FUNCTION_ALWAYS_THROWS_EXCEPTION = "TestFunctionAlwaysThrowsException";
    public static final String TEST_FUNCTION_RESULT_SENDER = "TestFunctionResultSender";
    public static final String MEMBER_FUNCTION = "MemberFunction";
    public static final String TEST_FUNCTION_SOCKET_TIMEOUT = "SocketTimeOutFunction";
    public static final String TEST_FUNCTION_TIMEOUT = "executeTimeOut";
    public static final String TEST_FUNCTION_HA = "executeFunctionHA";
    public static final String TEST_FUNCTION_NONHA = "executeFunctionNonHA";
    public static final String TEST_FUNCTION_HA_SERVER = "executeFunctionHAOnServer";
    public static final String TEST_FUNCTION_NONHA_SERVER = "executeFunctionNonHAOnServer";
    public static final String TEST_FUNCTION_NONHA_REGION = "executeFunctionNonHAOnRegion";
    public static final String TEST_FUNCTION_HA_REGION = "executeFunctionHAOnRegion";
    public static final String TEST_FUNCTION_REEXECUTE_EXCEPTION = "executeFunctionReexecuteException";
    public static final String TEST_FUNCTION_ONSERVER_REEXECUTE_EXCEPTION = "executeFunctionReexecuteExceptionOnServer";
    public static final String TEST_FUNCTION_NO_LASTRESULT = "executeFunctionWithoutLastResult";
    public static final String TEST_FUNCTION_LASTRESULT = "executeFunctionWithLastResult";
    public static final String TEST_FUNCTION_SEND_EXCEPTION = "executeFunction_SendException";
    public static final String TEST_FUNCTION_THROW_EXCEPTION = "executeFunction_ThrowException";
    public static final String TEST_FUNCTION_RETURN_ARGS = "executeFunctionToReturnArgs";
    public static final String TEST_FUNCTION_ON_ONE_MEMBER_RETURN_ARGS = "executeFunctionOnOneMemberToReturnArgs";
    public static final String TEST_FUNCTION_RUNNING_FOR_LONG_TIME = "executeFunctionRunningForLongTime";
    public static final String TEST_FUNCTION_BUCKET_FILTER = "TestFunctionBucketFilter";
    public static final String TEST_FUNCTION_NONHA_NOP = "executeFunctionNoHANop";
    private static final String ID = "id";
    private static final String HAVE_RESULTS = "haveResults";
    private final Properties props = new Properties();
    private static final String NOACKTEST = "NoAckTest";
    private static int retryCount = 0;
    private static int retryCountForExecuteFunctionReexecuteException = 0;
    private static int firstExecutionCount = 0;

    public TestFunction() {
    }

    public TestFunction(boolean haveResults, String id) {
        this.props.setProperty(HAVE_RESULTS, Boolean.toString(haveResults));
        this.props.setProperty(ID, id);
    }

    public TestFunction(boolean haveResults, String id, boolean hashCodeId) {
        this.props.setProperty(HAVE_RESULTS, Boolean.toString(haveResults));
        id = id + this.hashCode();
        this.props.setProperty(ID, id);
        this.props.setProperty(NOACKTEST, Boolean.toString(hashCodeId));
    }

    public void execute(FunctionContext context) {
        String id = this.props.getProperty(ID);
        String noAckTest = this.props.getProperty(NOACKTEST);
        if (id.equals(TEST_FUNCTION1) || id.equals(TEST_FUNCTION_ON_ONE_MEMBER_RETURN_ARGS)) {
            this.execute1(context);
        } else if (id.equals(TEST_FUNCTION2)) {
            this.execute2(context);
        } else if (id.equals(TEST_FUNCTION3)) {
            this.execute3(context);
        } else if (id.equals(TEST_FUNCTION4) || id.equals(TEST_FUNCTION7)) {
            this.execute4(context);
        } else if (id.equals(TEST_FUNCTION5) || id.equals(TEST_FUNCTION6)) {
            this.execute5(context);
        } else if (id.equals(TEST_FUNCTION8)) {
            this.execute8(context);
        } else if (id.equals(TEST_FUNCTION9)) {
            this.execute9(context);
        } else if (id.equals(TEST_FUNCTION_ALWAYS_THROWS_EXCEPTION)) {
            this.executeAlwaysException(context);
        } else if (id.equals(TEST_FUNCTION_EXCEPTION)) {
            this.executeException(context);
        } else if (id.equals(TEST_FUNCTION_REEXECUTE_EXCEPTION)) {
            this.executeFunctionReexecuteException(context);
        } else if (id.equals(TEST_FUNCTION_RESULT_SENDER)) {
            this.executeResultSender(context);
        } else if (id.equals(MEMBER_FUNCTION)) {
            this.executeMemberFunction(context);
        } else if (id.equals(TEST_FUNCTION_TIMEOUT)) {
            this.executeTimeOut(context);
        } else if (id.equals(TEST_FUNCTION_SOCKET_TIMEOUT)) {
            this.executeSocketTimeOut(context);
        } else if (id.equals(TEST_FUNCTION_HA)) {
            this.executeHA(context);
        } else if (id.equals(TEST_FUNCTION_NONHA)) {
            this.executeHA(context);
        } else if (id.equals(TEST_FUNCTION_HA_SERVER) || id.equals(TEST_FUNCTION_NONHA_SERVER)) {
            this.executeHAAndNonHAOnServer(context);
        } else if (id.equals(TEST_FUNCTION_NONHA_REGION) || id.equals(TEST_FUNCTION_HA_REGION)) {
            this.executeHAAndNonHAOnRegion(context);
        } else if (id.equals(TEST_FUNCTION_ONSERVER_REEXECUTE_EXCEPTION)) {
            this.executeFunctionReexecuteExceptionOnServer(context);
        } else if (id.equals(TEST_FUNCTION_NO_LASTRESULT)) {
            this.executeWithNoLastResult(context);
        } else if (id.equals(TEST_FUNCTION_SEND_EXCEPTION)) {
            this.executeWithSendException(context);
        } else if (id.equals(TEST_FUNCTION_THROW_EXCEPTION)) {
            this.executeWithThrowException(context);
        } else if (id.equals(TEST_FUNCTION_LASTRESULT)) {
            this.executeWithLastResult(context);
        } else if (id.equals(TEST_FUNCTION_RETURN_ARGS)) {
            this.executeFunctionReturningArgs(context);
        } else if (id.equals(TEST_FUNCTION_RUNNING_FOR_LONG_TIME)) {
            this.executeFunctionRunningForLongTime(context);
        } else if (id.equals(TEST_FUNCTION_BUCKET_FILTER)) {
            this.executeFunctionBucketFilter(context);
        } else if (id.equals(TEST_FUNCTION_NONHA_NOP)) {
            this.execute1(context);
        } else if (noAckTest.equals("true")) {
            this.execute1(context);
        }
    }

    private void executeFunctionRunningForLongTime(FunctionContext context) {
        Logger logger = LogService.getLogger();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            logger.info("Exception in executeFunctionRunningForLongTime");
        }
        context.getResultSender().lastResult((Object)"Ran executeFunctionRunningForLongTime for 2000");
    }

    private void executeFunctionBucketFilter(FunctionContext context) {
        RegionFunctionContextImpl rfc = (RegionFunctionContextImpl)context;
        PartitionedRegion pr = (PartitionedRegion)rfc.getDataSet();
        int[] bucketIDs = rfc.getLocalBucketArray((Region)pr);
        pr.getGemFireCache().getLogger().fine("LOCAL BUCKETSET =" + Arrays.toString(bucketIDs));
        ResultSender rs = context.getResultSender();
        if (!pr.getDataStore().areAllBucketsHosted(bucketIDs)) {
            throw new AssertionError((Object)("bucket IDs =" + Arrays.toString(bucketIDs) + " not all hosted locally"));
        }
        for (int i = 1; i < bucketIDs[0]; ++i) {
            rs.sendResult((Object)bucketIDs[i]);
        }
        rs.lastResult((Object)bucketIDs[bucketIDs[0]]);
    }

    private void executeFunctionReturningArgs(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        logger.info("Executing executeFunctionReturningArgs in TestFunction on Member : " + ds.getDistributedMember() + "with Context : " + context);
        if (!this.hasResult()) {
            return;
        }
        Object[] args = (Object[])context.getArguments();
        if (args != null) {
            context.getResultSender().lastResult(args[0]);
        } else {
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    private void execute1(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        logger.info("Executing execute1 in TestFunction on Member : " + ds.getDistributedMember() + "with Context : " + context);
        if (!this.hasResult()) {
            return;
        }
        if (context.getArguments() instanceof Boolean) {
            context.getResultSender().lastResult(context.getArguments());
        } else if (context.getArguments() instanceof String) {
            context.getResultSender().lastResult(context.getArguments());
        } else if (context.getArguments() instanceof Set) {
            Set origKeys = (Set)context.getArguments();
            ArrayList vals = new ArrayList();
            for (Object val : origKeys) {
                if (val == null) continue;
                vals.add(val);
            }
            context.getResultSender().lastResult(vals);
        } else {
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    private void execute2(FunctionContext context) {
        if (context instanceof RegionFunctionContext) {
            RegionFunctionContext rfContext = (RegionFunctionContext)context;
            rfContext.getDataSet().getCache().getLogger().info("Executing function :  TestFunction2.execute " + rfContext);
            if (rfContext.getArguments() instanceof Boolean) {
                if (this.hasResult()) {
                    rfContext.getResultSender().lastResult(rfContext.getArguments());
                } else {
                    rfContext.getDataSet().getCache().getLogger().info("Executing function :  TestFunction2.execute " + rfContext);
                    while (!rfContext.getDataSet().isDestroyed()) {
                        rfContext.getDataSet().getCache().getLogger().info("For Bug43513 ");
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                }
            } else if (rfContext.getArguments() instanceof String) {
                String key = (String)rfContext.getArguments();
                if (key.equals("TestingTimeOut")) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        rfContext.getDataSet().getCache().getLogger().warning("Got Exception : Thread Interrupted" + e);
                    }
                }
                if (PartitionRegionHelper.isPartitionedRegion((Region)rfContext.getDataSet())) {
                    rfContext.getResultSender().lastResult(PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rfContext).get((Object)key));
                } else {
                    rfContext.getResultSender().lastResult(rfContext.getDataSet().get((Object)key));
                }
            } else if (rfContext.getArguments() instanceof Set) {
                Set origKeys = (Set)rfContext.getArguments();
                ArrayList<Object> vals = new ArrayList<Object>();
                for (Object key : origKeys) {
                    Object val = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rfContext).get(key);
                    if (val == null) continue;
                    vals.add(val);
                }
                rfContext.getResultSender().lastResult(vals);
            } else if (rfContext.getArguments() instanceof HashMap) {
                HashMap putData = (HashMap)rfContext.getArguments();
                Iterator vals = putData.entrySet().iterator();
                while (vals.hasNext()) {
                    Map.Entry o;
                    Map.Entry me = o = vals.next();
                    rfContext.getDataSet().put(me.getKey(), me.getValue());
                }
                rfContext.getResultSender().lastResult((Object)Boolean.TRUE);
            } else {
                rfContext.getResultSender().lastResult((Object)Boolean.FALSE);
            }
        } else if (this.hasResult()) {
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        } else {
            InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
            LogWriter logger = ds.getLogWriter();
            logger.info("Executing in TestFunction on Server : " + ds.getDistributedMember() + "with Context : " + context);
            while (ds.isConnected()) {
                logger.fine("Just executing function in infinite loop for Bug43513");
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    private void execute3(FunctionContext context) {
        if (context instanceof RegionFunctionContext) {
            RegionFunctionContext prContext = (RegionFunctionContext)context;
            prContext.getDataSet().getCache().getLogger().info("Executing function : TestFunction3.execute " + prContext);
            if (prContext.getArguments() instanceof Set) {
                Set origKeys = (Set)prContext.getArguments();
                ArrayList<Object> vals = new ArrayList<Object>();
                for (Object origKey : origKeys) {
                    Object val = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)prContext).get(origKey);
                    if (val == null) continue;
                    vals.add(val);
                }
                prContext.getResultSender().lastResult(vals);
            } else if (prContext.getFilter() != null) {
                Set origKeys = prContext.getFilter();
                ArrayList<Object> vals = new ArrayList<Object>();
                for (Object origKey : origKeys) {
                    Object val = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)prContext).get(origKey);
                    if (val == null) continue;
                    vals.add(val);
                }
                prContext.getResultSender().lastResult(vals);
            } else {
                prContext.getResultSender().lastResult((Object)Boolean.FALSE);
            }
        } else {
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    private void execute4(FunctionContext context) {
        if (context instanceof RegionFunctionContext) {
            RegionFunctionContext prContext = (RegionFunctionContext)context;
            prContext.getDataSet().getCache().getLogger().info("Executing function :  TestFunction4-7.execute " + prContext);
            if (prContext.getArguments() instanceof Boolean) {
                if (this.hasResult()) {
                    prContext.getResultSender().lastResult(prContext.getArguments());
                }
            } else if (prContext.getArguments() instanceof String) {
                String key = (String)prContext.getArguments();
                prContext.getResultSender().lastResult(PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)prContext).get((Object)key));
            } else if (prContext.getArguments() instanceof Set) {
                Set origKeys = (Set)prContext.getArguments();
                ArrayList<Object> vals = new ArrayList<Object>();
                for (Object origKey : origKeys) {
                    Object val = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)prContext).get(origKey);
                    if (val == null) continue;
                    vals.add(val);
                }
                if (this.hasResult()) {
                    prContext.getResultSender().lastResult(vals);
                }
            } else if (prContext.getArguments() instanceof HashMap) {
                HashMap putData = (HashMap)prContext.getArguments();
                Iterator iterator = putData.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry me = o = iterator.next();
                    prContext.getDataSet().put(me.getKey(), me.getValue());
                }
                if (this.hasResult()) {
                    prContext.getResultSender().lastResult((Object)Boolean.TRUE);
                }
            } else if (this.hasResult()) {
                prContext.getResultSender().lastResult((Object)Boolean.FALSE);
            }
        } else if (this.hasResult()) {
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    private void execute5(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        logger.info("Executing executeException in TestFunction on Member : " + ds.getDistributedMember() + "with Context : " + context);
        if (this.hasResult()) {
            if (context.getArguments() instanceof String) {
                context.getResultSender().lastResult((Object)"Success");
            } else {
                context.getResultSender().lastResult((Object)"Failure");
            }
        }
    }

    private void executeMemberFunction(FunctionContext context) {
        if (this.hasResult()) {
            if (context.getArguments() instanceof String) {
                String args = (String)context.getArguments();
                if (!args.equalsIgnoreCase("Key")) {
                    Assert.assertTrue((boolean)args.equals(InternalDistributedSystem.getAnyInstance().getDistributedMember().getId()), (Object)("Args was supposed to be [" + InternalDistributedSystem.getAnyInstance().getDistributedMember().getId() + "] but was:[" + args + "]"));
                }
                context.getResultSender().lastResult((Object)"Success");
            } else {
                context.getResultSender().lastResult((Object)"Failure");
            }
        }
    }

    private void execute8(FunctionContext context) {
        if (context instanceof RegionFunctionContext) {
            RegionFunctionContext rfContext = (RegionFunctionContext)context;
            rfContext.getDataSet().getCache().getLogger().info("Executing function :  TestFunction8.execute " + rfContext);
            if (rfContext.getArguments() instanceof Boolean) {
                rfContext.getResultSender().lastResult(rfContext.getArguments());
            } else if (rfContext.getArguments() instanceof String) {
                String op = (String)rfContext.getArguments();
                if (op.equals("DELETE")) {
                    Region r = rfContext.getDataSet();
                    Set s = rfContext.getFilter();
                    if (s == null) {
                        rfContext.getResultSender().lastResult((Object)Boolean.FALSE);
                    }
                    for (Object value : s) {
                        r.destroy(value);
                    }
                    rfContext.getResultSender().lastResult((Object)Boolean.TRUE);
                } else if (op.equals("GET")) {
                    Region r = rfContext.getDataSet();
                    Set s = rfContext.getFilter();
                    if (s == null) {
                        rfContext.getResultSender().lastResult((Object)Boolean.FALSE);
                    }
                    Iterator itr = s.iterator();
                    ArrayList<Object> vals = new ArrayList<Object>();
                    while (itr.hasNext()) {
                        vals.add(r.get(itr.next()));
                    }
                    rfContext.getResultSender().lastResult(vals);
                }
                rfContext.getResultSender().lastResult((Object)Boolean.FALSE);
            } else {
                rfContext.getResultSender().lastResult((Object)Boolean.FALSE);
            }
        } else {
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute9(FunctionContext context) {
        if (context instanceof RegionFunctionContext) {
            RegionFunctionContext rfContext = (RegionFunctionContext)context;
            rfContext.getDataSet().getCache().getLogger().info("Executing function :  TestFunction9.execute " + rfContext);
            if (rfContext.getArguments() instanceof Boolean) {
                rfContext.getResultSender().lastResult(rfContext.getArguments());
            } else if (rfContext.getArguments() instanceof String) {
                RegionFunctionContext prContext;
                String key = (String)rfContext.getArguments();
                if (key.equals("TestingTimeOut")) {
                    try {
                        TestFunction testFunction = this;
                        synchronized (testFunction) {
                            this.wait(2000L);
                        }
                    }
                    catch (InterruptedException e) {
                        rfContext.getDataSet().getCache().getLogger().warning("Got Exception : Thread Interrupted" + e);
                    }
                }
                if (context instanceof RegionFunctionContext && PartitionRegionHelper.isPartitionedRegion((Region)(prContext = (RegionFunctionContext)context).getDataSet())) {
                    rfContext.getResultSender().lastResult(PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)prContext).get((Object)key));
                }
            } else if (rfContext.getArguments() instanceof Set) {
                Set origKeys = (Set)rfContext.getArguments();
                Iterator i = origKeys.iterator();
                while (i.hasNext()) {
                    Object val;
                    if (context instanceof RegionFunctionContext) {
                        RegionFunctionContext prContext = (RegionFunctionContext)context;
                        val = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)prContext).get(i.next());
                    } else {
                        val = rfContext.getDataSet().get(i.next());
                    }
                    if (i.hasNext()) {
                        rfContext.getResultSender().sendResult(val);
                        continue;
                    }
                    rfContext.getResultSender().lastResult(val);
                }
            } else if (rfContext.getArguments() instanceof HashMap) {
                HashMap putData = (HashMap)rfContext.getArguments();
                Iterator iterator = putData.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry me = o = iterator.next();
                    rfContext.getDataSet().put(me.getKey(), me.getValue());
                }
                rfContext.getResultSender().lastResult((Object)Boolean.TRUE);
            } else {
                rfContext.getResultSender().lastResult((Object)Boolean.TRUE);
            }
        }
        context.getResultSender().lastResult((Object)"ABCD");
    }

    private void executeException(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        logger.fine("Executing executeException in TestFunction on Member : " + ds.getDistributedMember() + "with Context : " + context);
        if (context.getArguments() instanceof Boolean) {
            logger.fine("MyFunctionExecutionException Exception is intentionally thrown");
            throw new MyFunctionExecutionException("I have been thrown from TestFunction");
        }
        if (context.getArguments() instanceof String) {
            String key = (String)context.getArguments();
            logger.fine("Result sent back :" + key);
            context.getResultSender().lastResult((Object)key);
        } else if (context.getArguments() instanceof Set) {
            Set origKeys = (Set)context.getArguments();
            ArrayList vals = new ArrayList();
            for (Object val : origKeys) {
                if (val == null) continue;
                vals.add(val);
            }
            logger.fine("Result sent back :" + vals);
            context.getResultSender().lastResult(vals);
        } else {
            logger.fine("Result sent back :" + Boolean.FALSE);
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    private void executeAlwaysException(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        logger.fine("Executing executeException in TestFunction on Member : " + ds.getDistributedMember() + "with Context : " + context);
        logger.fine("MyFunctionExecutionException Exception is intentionally thrown");
        throw new MyFunctionExecutionException("I have been thrown from TestFunction");
    }

    private void executeWithSendException(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        logger.fine("Executing executeWithSendException in TestFunction on Member : " + ds.getDistributedMember() + "with Context : " + context);
        if (context.getArguments() instanceof Boolean) {
            context.getResultSender().sendException((Throwable)new MyFunctionExecutionException("I have been send from TestFunction"));
        } else if (context.getArguments() instanceof String) {
            String arg = (String)context.getArguments();
            if (arg.equals("Multiple")) {
                logger.fine("Sending Exception First time");
                context.getResultSender().sendException((Throwable)new MyFunctionExecutionException("I have been send from TestFunction"));
                logger.fine("Sending Exception Second time");
                context.getResultSender().sendException((Throwable)new MyFunctionExecutionException("I have been send from TestFunction"));
            }
        } else if (context.getArguments() instanceof Set) {
            Set args = (Set)context.getArguments();
            for (int i = 0; i < args.size(); ++i) {
                context.getResultSender().sendResult((Object)i);
            }
            context.getResultSender().sendException((Throwable)new MyFunctionExecutionException("I have been thrown from TestFunction with set"));
        } else {
            logger.fine("Result sent back :" + Boolean.FALSE);
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    private void executeWithThrowException(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        RegionFunctionContext rfContext = (RegionFunctionContext)context;
        LogWriter logger = ds.getLogWriter();
        logger.fine("Executing executeWithThrowException in TestFunction on Member : " + ds.getDistributedMember() + "with Context : " + context);
        if (context.getArguments() instanceof Boolean) {
            logger.fine("MyFunctionExecutionException Exception is intentionally thrown");
            throw new MyFunctionExecutionException("I have been thrown from TestFunction");
        }
        if (rfContext.getArguments() instanceof Set) {
            Set origKeys = (Set)rfContext.getArguments();
            for (Object origKey : origKeys) {
                Object key;
                Region r = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rfContext);
                Object val = r.get(key = origKey);
                if (val == null) continue;
                throw new MyFunctionExecutionException("I have been thrown from TestFunction");
            }
        } else {
            logger.fine("Result sent back :" + Boolean.FALSE);
            rfContext.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    private synchronized void executeFunctionReexecuteException(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        logger.fine("Executing executeException in TestFunction on Member : " + ds.getDistributedMember() + "with Context : " + context);
        if (++retryCountForExecuteFunctionReexecuteException >= 5) {
            logger.fine("Tried Function Execution 5 times. Now Returning after 5 attempts");
            context.getResultSender().lastResult((Object)retryCountForExecuteFunctionReexecuteException);
            retryCountForExecuteFunctionReexecuteException = 0;
            return;
        }
        if (context.getArguments() instanceof Boolean) {
            logger.fine("MyFunctionExecutionException is intentionally thrown");
            throw new FunctionInvocationTargetException((Throwable)new MyFunctionExecutionException("I have been thrown from TestFunction"));
        }
    }

    private void executeResultSender(FunctionContext context) {
        ResultSender resultSender = context.getResultSender();
        if (context instanceof RegionFunctionContext) {
            RegionFunctionContext rfContext = (RegionFunctionContext)context;
            rfContext.getDataSet().getCache().getLogger().info("Executing function :  TestFunctionexecuteResultSender.execute " + rfContext);
            if (rfContext.getArguments() instanceof Boolean) {
                if (this.hasResult()) {
                    resultSender.lastResult(rfContext.getArguments());
                }
            } else if (rfContext.getArguments() instanceof Set) {
                int i;
                Set origKeys = (Set)rfContext.getArguments();
                Object[] objectArray = origKeys.toArray();
                int size = objectArray.length;
                for (i = 0; i < size - 1; ++i) {
                    Object val = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rfContext).get(objectArray[i]);
                    if (val == null) continue;
                    resultSender.sendResult(val);
                }
                resultSender.lastResult(objectArray[i]);
            } else {
                resultSender.lastResult((Object)Boolean.FALSE);
            }
        } else {
            resultSender.lastResult((Object)Boolean.FALSE);
        }
    }

    private void executeSocketTimeOut(FunctionContext context) {
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (context.getArguments() instanceof Boolean) {
            context.getResultSender().lastResult(context.getArguments());
        } else if (context.getArguments() instanceof String) {
            context.getResultSender().lastResult(context.getArguments());
        } else if (context.getArguments() instanceof Set) {
            Set origKeys = (Set)context.getArguments();
            ArrayList vals = new ArrayList();
            for (Object val : origKeys) {
                if (val == null) continue;
                vals.add(val);
            }
            context.getResultSender().lastResult(vals);
        } else {
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTimeOut(FunctionContext context) {
        try {
            TestFunction testFunction = this;
            synchronized (testFunction) {
                this.wait(2000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (context instanceof RegionFunctionContext) {
            RegionFunctionContext rfContext = (RegionFunctionContext)context;
            rfContext.getDataSet().getCache().getLogger().info("Executing function :  TestFunction.execute " + rfContext);
            if (rfContext.getArguments() instanceof Boolean) {
                rfContext.getResultSender().lastResult(rfContext.getArguments());
            } else if (rfContext.getArguments() instanceof String) {
                String key = (String)rfContext.getArguments();
                if (key.equals("TestingTimeOut")) {
                    try {
                        TestFunction testFunction = this;
                        synchronized (testFunction) {
                            this.wait(2000L);
                        }
                    }
                    catch (InterruptedException e) {
                        rfContext.getDataSet().getCache().getLogger().warning("Got Exception : Thread Interrupted" + e);
                    }
                }
                try {
                    TestFunction e = this;
                    synchronized (e) {
                        this.wait(2000L);
                    }
                }
                catch (InterruptedException e) {
                    rfContext.getDataSet().getCache().getLogger().warning("Got Exception : Thread Interrupted" + e);
                }
                if (PartitionRegionHelper.isPartitionedRegion((Region)rfContext.getDataSet())) {
                    rfContext.getResultSender().lastResult(PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rfContext).get((Object)key));
                } else {
                    rfContext.getResultSender().lastResult(rfContext.getDataSet().get((Object)key));
                }
            } else if (rfContext.getArguments() instanceof Set) {
                Set origKeys = (Set)rfContext.getArguments();
                ArrayList<Object> vals = new ArrayList<Object>();
                for (Object origKey : origKeys) {
                    Object val = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rfContext).get(origKey);
                    if (val == null) continue;
                    vals.add(val);
                }
                rfContext.getResultSender().lastResult(vals);
            } else if (rfContext.getArguments() instanceof HashMap) {
                HashMap putData = (HashMap)rfContext.getArguments();
                Iterator iterator = putData.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry me = o = iterator.next();
                    rfContext.getDataSet().put(me.getKey(), me.getValue());
                }
                rfContext.getResultSender().lastResult((Object)Boolean.TRUE);
            } else {
                rfContext.getResultSender().lastResult((Object)Boolean.FALSE);
            }
        } else {
            context.getResultSender().lastResult((Object)Boolean.FALSE);
        }
    }

    private void executeHA(FunctionContext context) {
        RegionFunctionContext rcontext = (RegionFunctionContext)context;
        Region region = rcontext.getDataSet();
        region.getCache().getLogger().fine("executeHA#execute( " + rcontext + " )");
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        rcontext.getResultSender().lastResult(rcontext.getArguments());
    }

    private void executeHAAndNonHAOnServer(FunctionContext context) {
        block18: {
            Integer numTimesStopped;
            Region r;
            List servers;
            block17: {
                servers = CacheFactory.getAnyInstance().getCacheServers();
                ArrayList args = (ArrayList)context.getArguments();
                r = CacheFactory.getAnyInstance().getRegion((String)args.get(0));
                String testName = (String)args.get(1);
                numTimesStopped = (Integer)r.get((Object)"stopped");
                Integer numTimesSentResult = (Integer)r.get((Object)"sentresult");
                if (!context.isPossibleDuplicate()) break block17;
                switch (testName) {
                    case "serverExecutionHATwoServerDown": {
                        if ((Integer)r.get((Object)"stopped") == 2) {
                            if (numTimesSentResult == null) {
                                r.put((Object)"sentresult", (Object)1);
                            } else {
                                numTimesSentResult = numTimesSentResult + 1;
                                r.put((Object)"sentresult", (Object)numTimesSentResult);
                            }
                            context.getResultSender().lastResult(args.get(0));
                            break;
                        }
                        numTimesStopped = numTimesStopped + 1;
                        r.put((Object)"stopped", (Object)numTimesStopped);
                        for (CacheServer s : servers) {
                            if (!((CacheServerImpl)s).getSystem().getDistributedMember().equals((Object)((GemFireCacheImpl)CacheFactory.getAnyInstance()).getMyId())) continue;
                            s.stop();
                            InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
                            ds.disconnect();
                        }
                        break block18;
                    }
                    case "serverExecutionHAOneServerDown": {
                        if (numTimesSentResult == null) {
                            r.put((Object)"sentresult", (Object)1);
                        } else {
                            numTimesSentResult = numTimesSentResult + 1;
                            r.put((Object)"sentresult", (Object)numTimesSentResult);
                        }
                        context.getResultSender().lastResult(args.get(0));
                        break;
                    }
                    default: {
                        context.getResultSender().lastResult(args.get(0));
                    }
                }
                break block18;
            }
            if (numTimesStopped == null) {
                r.put((Object)"stopped", (Object)1);
            } else {
                numTimesStopped = numTimesStopped + 1;
                r.put((Object)"stopped", (Object)numTimesStopped);
            }
            for (CacheServer s : servers) {
                if (!((CacheServerImpl)s).getSystem().getDistributedMember().equals((Object)((GemFireCacheImpl)CacheFactory.getAnyInstance()).getMyId())) continue;
                s.stop();
                InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
                ds.disconnect();
            }
        }
    }

    private void executeHAAndNonHAOnRegion(FunctionContext context) {
        List servers = CacheFactory.getAnyInstance().getCacheServers();
        ArrayList args = (ArrayList)context.getArguments();
        RegionFunctionContext rfContext = (RegionFunctionContext)context;
        rfContext.getDataSet().getCache().getLogger().info("Executing function :  executeHAAndNonHAOnRegion " + rfContext);
        Region r = CacheFactory.getAnyInstance().getRegion((String)args.get(0));
        String testName = (String)args.get(1);
        Integer numTimesStopped = (Integer)r.get((Object)"stopped");
        Integer numTimesSentResult = (Integer)r.get((Object)"sentresult");
        if (context.isPossibleDuplicate()) {
            if (testName.equals("regionExecutionHATwoServerDown")) {
                if ((Integer)r.get((Object)"stopped") == 2) {
                    if (numTimesSentResult == null) {
                        r.put((Object)"sentresult", (Object)1);
                    } else {
                        numTimesSentResult = numTimesSentResult + 1;
                        r.put((Object)"sentresult", (Object)numTimesSentResult);
                    }
                    context.getResultSender().lastResult(args.get(0));
                } else {
                    numTimesStopped = numTimesStopped + 1;
                    r.put((Object)"stopped", (Object)numTimesStopped);
                    for (CacheServer s : servers) {
                        if (!((CacheServerImpl)s).getSystem().getDistributedMember().equals((Object)((GemFireCacheImpl)CacheFactory.getAnyInstance()).getMyId())) continue;
                        s.stop();
                        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
                        ds.disconnect();
                    }
                }
            } else if (testName.equals("regionExecutionHAOneServerDown")) {
                if (numTimesSentResult == null) {
                    r.put((Object)"sentresult", (Object)1);
                } else {
                    numTimesSentResult = numTimesSentResult + 1;
                    r.put((Object)"sentresult", (Object)numTimesSentResult);
                }
                context.getResultSender().lastResult(args.get(0));
            } else {
                context.getResultSender().lastResult(args.get(0));
            }
        } else {
            if (numTimesStopped == null) {
                r.put((Object)"stopped", (Object)1);
            } else {
                numTimesStopped = numTimesStopped + 1;
                r.put((Object)"stopped", (Object)numTimesStopped);
            }
            for (CacheServer s : servers) {
                if (!((CacheServerImpl)s).getSystem().getDistributedMember().equals((Object)((GemFireCacheImpl)CacheFactory.getAnyInstance()).getMyId())) continue;
                s.stop();
                InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
                ds.disconnect();
            }
            context.getResultSender().lastResult(args.get(0));
        }
    }

    private synchronized void executeFunctionReexecuteExceptionOnServer(FunctionContext context) {
        if (context.isPossibleDuplicate()) {
            ++retryCount;
        } else {
            ++firstExecutionCount;
        }
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        logger.fine("Executing executeException in TestFunction on Member : " + ds.getDistributedMember() + "with Context : " + context);
        if (retryCount >= 5) {
            logger.fine("Tried Function Execution 5 times. Now Returning after 5 attempts");
            context.getResultSender().sendResult((Object)firstExecutionCount);
            context.getResultSender().lastResult((Object)retryCount);
            firstExecutionCount = 0;
            retryCount = 0;
            return;
        }
        if (context.getArguments() instanceof Boolean) {
            logger.fine("MyFunctionExecutionException Exception is intentionally thrown");
            throw new InternalFunctionInvocationTargetException((Throwable)new MyFunctionExecutionException("I have been thrown from TestFunction"));
        }
    }

    private void executeWithNoLastResult(FunctionContext context) {
        InternalDistributedSystem.getConnectedInstance().getLogWriter().info("<ExpectedException action=add>did not send last result</ExpectedException>");
        context.getResultSender().sendResult(context.getArguments());
    }

    private void executeWithLastResult(FunctionContext context) {
        RegionFunctionContext rfContext = (RegionFunctionContext)context;
        PartitionedRegion pr = (PartitionedRegion)rfContext.getDataSet();
        ResourceManager resMan = pr.getCache().getResourceManager();
        RebalanceFactory factory = resMan.createRebalanceFactory();
        RebalanceOperation rebalanceOp = factory.start();
        try {
            rebalanceOp.getResults();
        }
        catch (InterruptedException | CancellationException e) {
            e.printStackTrace();
        }
        context.getResultSender().lastResult(context.getArguments());
    }

    public String getId() {
        return this.props.getProperty(ID);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TestFunction)) {
            return false;
        }
        TestFunction function = (TestFunction)obj;
        return this.props.equals(function.getConfig());
    }

    public int hashCode() {
        return Objects.hash(this.props);
    }

    public boolean hasResult() {
        return Boolean.valueOf(this.props.getProperty(HAVE_RESULTS));
    }

    public Properties getConfig() {
        return this.props;
    }

    public void init(Properties props) {
        this.props.putAll((Map<?, ?>)props);
    }

    public boolean isHA() {
        if (this.getId().equals(TEST_FUNCTION10)) {
            return true;
        }
        if (this.getId().equals(TEST_FUNCTION_NONHA_SERVER) || this.getId().equals(TEST_FUNCTION_NONHA_REGION) || this.getId().equals(TEST_FUNCTION_NONHA_NOP) || this.getId().equals(TEST_FUNCTION_NONHA)) {
            return false;
        }
        return Boolean.valueOf(this.props.getProperty(HAVE_RESULTS));
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeHashMap((Map)this.props, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        HashMap map = DataSerializer.readHashMap((DataInput)in);
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                this.props.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

