/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.internal.cli.commands.RebalanceCommand;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.dunit.rules.MemberVM;
import org.apache.geode.test.junit.assertions.TabularResultModelAssert;
import org.apache.geode.test.junit.rules.GfshCommandRule;
import org.apache.geode.test.junit.rules.MemberStarterRule;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RebalanceCommandDistributedTest
implements Serializable {
    private static final int ENTRIES_PER_REGION = 200;
    private static final String REGION_ONE_NAME = "region-1";
    private static final String REGION_TWO_NAME = "region-2";
    private static final String REGION_THREE_NAME = "region-3";
    @Rule
    public transient GfshCommandRule gfsh = new GfshCommandRule();
    @Rule
    public ClusterStartupRule cluster = new ClusterStartupRule();
    protected MemberVM locator;
    protected MemberVM server1;
    protected MemberVM server2;
    @Parameterized.Parameter
    public static GfshCommandRule.PortType portType;

    @Parameterized.Parameters(name="ConnectionType:{0}")
    public static GfshCommandRule.PortType[] connectionTypes() {
        return new GfshCommandRule.PortType[]{GfshCommandRule.PortType.http, GfshCommandRule.PortType.jmxManager};
    }

    private void setUpRegions() {
        this.server1.invoke(() -> {
            InternalCache cache = ClusterStartupRule.getCache();
            Assertions.assertThat((Object)cache).isNotNull();
            RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
            Region region1 = dataRegionFactory.create(REGION_ONE_NAME);
            Region region2 = dataRegionFactory.create(REGION_TWO_NAME);
            for (int i = 0; i < 200; ++i) {
                region1.put((Object)("key" + i), (Object)("Value" + i));
                region2.put((Object)("key" + i), (Object)("Value" + i));
            }
        });
        this.server2.invoke(() -> {
            InternalCache cache = ClusterStartupRule.getCache();
            Assertions.assertThat((Object)cache).isNotNull();
            RegionFactory dataRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
            dataRegionFactory.create(REGION_ONE_NAME);
            Region region3 = dataRegionFactory.create(REGION_THREE_NAME);
            for (int i = 0; i < 200; ++i) {
                region3.put((Object)("key" + i), (Object)("Value" + i));
            }
        });
    }

    @Before
    public void setUp() throws Exception {
        this.locator = this.cluster.startLocatorVM(0, MemberStarterRule::withHttpService);
        int locatorPort = this.locator.getPort();
        this.server1 = this.cluster.startServerVM(1, "localhost", locatorPort);
        this.server2 = this.cluster.startServerVM(2, "localhost", locatorPort);
        this.setUpRegions();
        switch (portType) {
            case http: {
                this.gfsh.connectAndVerify(this.locator.getHttpPort(), GfshCommandRule.PortType.http, new String[0]);
                break;
            }
            case jmxManager: {
                this.gfsh.connectAndVerify(this.locator.getJmxPort(), GfshCommandRule.PortType.jmxManager, new String[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid PortType Configured");
            }
        }
    }

    @Test
    public void testSimulateForEntireDSWithTimeout() {
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers("/region-1", 2);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers("/region-2", 1);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers("/region-3", 1);
        String command = "rebalance --simulate=true --time-out=-1";
        this.gfsh.executeAndAssertThat(command).statusIsSuccess();
    }

    @Test
    public void testRebalanceResultOutput() {
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers("/region-1", 2);
        String command = "rebalance";
        TabularResultModelAssert rebalanceResult = this.gfsh.executeAndAssertThat(command).statusIsSuccess().hasTableSection();
        rebalanceResult.hasHeader().contains(new CharSequence[]{"Rebalanced partition regions"});
        rebalanceResult.hasRow(0).contains((Object[])new String[]{"Total bytes in all redundant bucket copies created during this rebalance"});
        rebalanceResult.hasRow(1).contains((Object[])new String[]{"Total time (in milliseconds) spent creating redundant bucket copies during this rebalance"});
        rebalanceResult.hasRow(2).contains((Object[])new String[]{"Total number of redundant copies created during this rebalance"});
        rebalanceResult.hasRow(3).contains((Object[])new String[]{"Total bytes in buckets moved during this rebalance"});
        rebalanceResult.hasRow(4).contains((Object[])new String[]{"Total time (in milliseconds) spent moving buckets during this rebalance"});
        rebalanceResult.hasRow(5).contains((Object[])new String[]{"Total number of buckets moved during this rebalance"});
        rebalanceResult.hasRow(6).contains((Object[])new String[]{"Total time (in milliseconds) spent switching the primary state of buckets during this rebalance"});
        rebalanceResult.hasRow(7).contains((Object[])new String[]{"Total primaries transferred during this rebalance"});
        rebalanceResult.hasRow(8).contains((Object[])new String[]{"Total time (in milliseconds) for this rebalance"});
        rebalanceResult.hasRow(9).contains((Object[])new String[]{"Total number of members in system on which rebalance is executed"});
    }

    @Test
    public void testRebalanceResultOutputMemberCount() {
        MemberVM server3 = this.cluster.startServerVM(3, "localhost", this.locator.getPort());
        server3.invoke(() -> {
            InternalCache cache = ClusterStartupRule.getCache();
            Assertions.assertThat((Object)cache).isNotNull();
            cache.createRegionFactory(RegionShortcut.PARTITION).create(REGION_ONE_NAME);
        });
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers("/region-1", 3);
        Map listMembersResult = ((TabularResultModel)this.gfsh.executeAndAssertThat("list members").hasTableSection().getActual()).getContent();
        Assertions.assertThat((int)((List)listMembersResult.get("Name")).size()).isEqualTo(4);
        server3.forceDisconnect();
        Map rebalanceResult = ((TabularResultModel)this.gfsh.executeAndAssertThat("rebalance").statusIsSuccess().hasTableSection().getActual()).getContent();
        server3.waitTilFullyReconnected();
        listMembersResult = ((TabularResultModel)this.gfsh.executeAndAssertThat("list members").hasTableSection().getActual()).getContent();
        Assertions.assertThat((int)((List)listMembersResult.get("Name")).size()).isEqualTo(4);
        Assertions.assertThat((String)((String)((List)rebalanceResult.get("Rebalanced Stats")).get(9))).isEqualTo("Total number of members in system on which rebalance is executed");
        Assertions.assertThat((String)((String)((List)rebalanceResult.get("Value")).get(9))).isEqualTo("2");
    }

    @Test
    public void rebalanceCommandShouldNotLaunchNonDaemonThreads() {
        this.gfsh.executeAndAssertThat("rebalance").statusIsSuccess();
        this.locator.invoke(() -> ((AbstractBooleanAssert)Assertions.assertThat((boolean)Thread.getAllStackTraces().keySet().stream().anyMatch(thread -> !thread.isDaemon() && thread.getName().contains(RebalanceCommand.THREAD_NAME))).as("Rebalance Command should not launch non daemon threads", new Object[0])).isFalse());
    }
}

