/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.rules.AbstractDistributedRule;
import org.apache.geode.test.junit.rules.ExecutorServiceRule;

public class DistributedExecutorServiceRule
extends AbstractDistributedRule {
    private static final AtomicReference<ExecutorServiceRule> delegate = new AtomicReference();

    public DistributedExecutorServiceRule() {
    }

    public DistributedExecutorServiceRule(int vmCount) {
        super(vmCount);
    }

    public ExecutorService getExecutorService() {
        return delegate.get().getExecutorService();
    }

    public void execute(ExecutorServiceRule.ThrowingRunnable command) {
        delegate.get().execute(command);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return delegate.get().submit(task);
    }

    public <T> Future<T> submit(ExecutorServiceRule.ThrowingRunnable task, T result) {
        return delegate.get().submit(task, result);
    }

    public Future<Void> submit(ExecutorServiceRule.ThrowingRunnable task) {
        return delegate.get().submit(task);
    }

    public CompletableFuture<Void> runAsync(Runnable runnable) {
        return delegate.get().runAsync(runnable);
    }

    public <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        return delegate.get().supplyAsync(supplier);
    }

    public Set<Thread> getThreads() {
        return delegate.get().getThreads();
    }

    public long[] getThreadIds() {
        return delegate.get().getThreadIds();
    }

    public String dumpThreads() {
        return delegate.get().dumpThreads();
    }

    @Override
    public void before() throws Exception {
        this.invoker().invokeInEveryVMAndController(() -> this.invokeBefore());
    }

    @Override
    public void after() {
        this.invoker().invokeInEveryVMAndController(() -> this.invokeAfter());
    }

    @Override
    protected void afterCreateVM(VM vm) {
        vm.invoke(() -> this.invokeBefore());
    }

    @Override
    protected void afterBounceVM(VM vm) {
        vm.invoke(() -> this.invokeBefore());
    }

    private void invokeBefore() throws Exception {
        try {
            delegate.set(new ExecutorServiceRule());
            delegate.get().before();
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    private void invokeAfter() {
        delegate.get().after();
    }
}

