/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.annotations.internal.MakeNotStatic;

public class AsyncThreadId {
    private static final AtomicLong ASYNC_ID_COUNTER = new AtomicLong();
    @MakeNotStatic
    private static final Map<Long, Long> ASYNC_THREAD_ID_MAP = new ConcurrentHashMap<Long, Long>();

    public static long nextId() {
        return ASYNC_ID_COUNTER.incrementAndGet();
    }

    public static void put(long asyncId, long threadId) {
        ASYNC_THREAD_ID_MAP.put(asyncId, threadId);
    }

    public static void remove(long asyncId) {
        ASYNC_THREAD_ID_MAP.remove(asyncId);
    }

    public static long get(long asyncId) {
        return ASYNC_THREAD_ID_MAP.get(asyncId);
    }
}

