/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management;

import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.management.AsyncEventQueueMXBean;
import org.apache.geode.management.CacheServerMXBean;
import org.apache.geode.management.DistributedLockServiceMXBean;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.GatewayReceiverMXBean;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.LocatorMXBean;
import org.apache.geode.management.LockServiceMXBean;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.ManagementTestBase;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.RegionMXBean;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.test.dunit.LogWriterUtils;
import org.apache.geode.test.dunit.Wait;
import org.apache.geode.test.dunit.WaitCriterion;
import org.junit.Assert;

public class MBeanUtil {
    private static final int MAX_WAIT = 16000;
    public static MBeanServer mbeanServer = MBeanJMXAdapter.mbeanServer;

    public static MemberMXBean getMemberMbeanProxy(DistributedMember member) throws Exception {
        MemberMXBean bean;
        block2: {
            bean = null;
            final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
            final ObjectName memberMBeanName = service.getMemberMBeanName(member);
            Wait.waitForCriterion(new WaitCriterion(){
                MemberMXBean bean = null;

                @Override
                public String description() {
                    return "Waiting for the proxy to get reflected at managing node";
                }

                @Override
                public boolean done() {
                    this.bean = (MemberMXBean)service.getMBeanProxy(memberMBeanName, MemberMXBean.class);
                    boolean done = this.bean != null;
                    return done;
                }
            }, 16000L, 500L, true);
            try {
                bean = (MemberMXBean)service.getMBeanProxy(memberMBeanName, MemberMXBean.class);
            }
            catch (ManagementException mgz) {
                if (bean != null) break block2;
                InternalDistributedSystem.getLogger().fine("Undesired Result :MemberMBean Proxy Should Not be Empty for : " + memberMBeanName.getCanonicalName());
            }
        }
        return bean;
    }

    public static CacheServerMXBean getCacheServerMbeanProxy(DistributedMember member, int port) throws Exception {
        CacheServerMXBean bean;
        block2: {
            bean = null;
            final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
            final ObjectName cacheServerMBeanName = service.getCacheServerMBeanName(port, member);
            Wait.waitForCriterion(new WaitCriterion(){
                CacheServerMXBean bean = null;

                @Override
                public String description() {
                    return "Waiting for the proxy to get reflected at managing node";
                }

                @Override
                public boolean done() {
                    GemFireCacheImpl cache;
                    GemFireCacheImpl cacheImpl = cache = GemFireCacheImpl.getInstance();
                    this.bean = (CacheServerMXBean)service.getMBeanProxy(cacheServerMBeanName, CacheServerMXBean.class);
                    boolean done = this.bean != null;
                    return done;
                }
            }, 16000L, 500L, true);
            try {
                bean = (CacheServerMXBean)service.getMBeanProxy(cacheServerMBeanName, CacheServerMXBean.class);
            }
            catch (ManagementException mgz) {
                if (bean != null) break block2;
                InternalDistributedSystem.getLogger().fine("Undesired Result :CacheServer Proxy Should Not be Empty for : " + cacheServerMBeanName.getCanonicalName());
            }
        }
        return bean;
    }

    public static LockServiceMXBean getLockServiceMbeanProxy(DistributedMember member, String lockServiceName) throws Exception {
        LockServiceMXBean bean;
        block2: {
            bean = null;
            final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
            final ObjectName lockServiceMBeanName = service.getLockServiceMBeanName(member, lockServiceName);
            Wait.waitForCriterion(new WaitCriterion(){
                LockServiceMXBean bean = null;

                @Override
                public String description() {
                    return "Waiting for the proxy to get reflected at managing node";
                }

                @Override
                public boolean done() {
                    GemFireCacheImpl cache;
                    GemFireCacheImpl cacheImpl = cache = GemFireCacheImpl.getInstance();
                    this.bean = (LockServiceMXBean)service.getMBeanProxy(lockServiceMBeanName, LockServiceMXBean.class);
                    boolean done = this.bean != null;
                    return done;
                }
            }, 16000L, 500L, true);
            try {
                bean = (LockServiceMXBean)service.getMBeanProxy(lockServiceMBeanName, LockServiceMXBean.class);
            }
            catch (ManagementException mgz) {
                if (bean != null) break block2;
                InternalDistributedSystem.getLogger().fine("Undesired Result :LockService Proxy Should Not be Empty for : " + lockServiceMBeanName.getCanonicalName());
            }
        }
        return bean;
    }

    public static RegionMXBean getRegionMbeanProxy(DistributedMember member, String regionPath) throws Exception {
        RegionMXBean bean;
        block2: {
            final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
            final ObjectName regionMBeanName = service.getRegionMBeanName(member, regionPath);
            Wait.waitForCriterion(new WaitCriterion(){
                RegionMXBean bean = null;

                @Override
                public String description() {
                    return "Waiting for the proxy to get reflected at managing node";
                }

                @Override
                public boolean done() {
                    GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                    this.bean = (RegionMXBean)service.getMBeanProxy(regionMBeanName, RegionMXBean.class);
                    boolean done = this.bean != null;
                    return done;
                }
            }, 16000L, 500L, true);
            bean = null;
            try {
                bean = (RegionMXBean)service.getMBeanProxy(regionMBeanName, RegionMXBean.class);
            }
            catch (ManagementException mgz) {
                if (bean != null) break block2;
                InternalDistributedSystem.getLogger().fine("Undesired Result :RegionMBean Proxy Should Not be Empty for : " + regionMBeanName.getCanonicalName());
            }
        }
        return bean;
    }

    public static GatewaySenderMXBean getGatewaySenderMbeanProxy(DistributedMember member, String gatwaySenderId) throws Exception {
        GatewaySenderMXBean bean;
        block2: {
            final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
            final ObjectName senderMBeanName = service.getGatewaySenderMBeanName(member, gatwaySenderId);
            Wait.waitForCriterion(new WaitCriterion(){
                GatewaySenderMXBean bean = null;

                @Override
                public String description() {
                    return "Waiting for the proxy to get reflected at managing node";
                }

                @Override
                public boolean done() {
                    GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                    this.bean = (GatewaySenderMXBean)service.getMBeanProxy(senderMBeanName, GatewaySenderMXBean.class);
                    boolean done = this.bean != null;
                    return done;
                }
            }, 16000L, 500L, true);
            bean = null;
            try {
                bean = (GatewaySenderMXBean)service.getMBeanProxy(senderMBeanName, GatewaySenderMXBean.class);
            }
            catch (ManagementException mgz) {
                if (bean != null) break block2;
                InternalDistributedSystem.getLogger().fine("Undesired Result :GatewaySender MBean Proxy Should Not be Empty for : " + senderMBeanName.getCanonicalName());
            }
        }
        return bean;
    }

    public static AsyncEventQueueMXBean getAsyncEventQueueMBeanProxy(DistributedMember member, String queueId) throws Exception {
        AsyncEventQueueMXBean bean;
        block2: {
            final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
            final ObjectName queueMBeanName = service.getAsyncEventQueueMBeanName(member, queueId);
            Wait.waitForCriterion(new WaitCriterion(){
                AsyncEventQueueMXBean bean = null;

                @Override
                public String description() {
                    return "Waiting for the proxy to get reflected at managing node";
                }

                @Override
                public boolean done() {
                    GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                    this.bean = (AsyncEventQueueMXBean)service.getMBeanProxy(queueMBeanName, AsyncEventQueueMXBean.class);
                    boolean done = this.bean != null;
                    return done;
                }
            }, 16000L, 500L, true);
            bean = null;
            try {
                bean = (AsyncEventQueueMXBean)service.getMBeanProxy(queueMBeanName, AsyncEventQueueMXBean.class);
            }
            catch (ManagementException mgz) {
                if (bean != null) break block2;
                InternalDistributedSystem.getLogger().fine("Undesired Result :Async Event Queue MBean Proxy Should Not be Empty for : " + queueMBeanName.getCanonicalName());
            }
        }
        return bean;
    }

    public static GatewayReceiverMXBean getGatewayReceiverMbeanProxy(DistributedMember member) throws Exception {
        GatewayReceiverMXBean bean;
        block2: {
            final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
            final ObjectName receiverMBeanName = service.getGatewayReceiverMBeanName(member);
            Wait.waitForCriterion(new WaitCriterion(){
                GatewayReceiverMXBean bean = null;

                @Override
                public String description() {
                    return "Waiting for the proxy to get reflected at managing node";
                }

                @Override
                public boolean done() {
                    GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                    this.bean = (GatewayReceiverMXBean)service.getMBeanProxy(receiverMBeanName, GatewayReceiverMXBean.class);
                    boolean done = this.bean != null;
                    return done;
                }
            }, 16000L, 500L, true);
            bean = null;
            try {
                bean = (GatewayReceiverMXBean)service.getMBeanProxy(receiverMBeanName, GatewayReceiverMXBean.class);
            }
            catch (ManagementException mgz) {
                if (bean != null) break block2;
                InternalDistributedSystem.getLogger().fine("Undesired Result :GatewaySender MBean Proxy Should Not be Empty for : " + receiverMBeanName.getCanonicalName());
            }
        }
        return bean;
    }

    public static DistributedRegionMXBean getDistributedRegionMbean(final String regionName, final int expectedMembers) throws Exception {
        DistributedRegionMXBean bean = null;
        final ManagementService service = ManagementTestBase.getManagementService();
        Wait.waitForCriterion(new WaitCriterion(){
            DistributedRegionMXBean bean = null;

            @Override
            public String description() {
                return "Waiting for " + regionName + " With " + expectedMembers + " proxies to get reflected at managing node";
            }

            @Override
            public boolean done() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                this.bean = service.getDistributedRegionMXBean(regionName);
                boolean done = this.bean != null && this.bean.getMemberCount() == expectedMembers;
                return done;
            }
        }, 16000L, 1000L, true);
        bean = service.getDistributedRegionMXBean(regionName);
        return bean;
    }

    public static DistributedLockServiceMXBean getDistributedLockMbean(final String lockServiceName, final int expectedMembers) throws Exception {
        DistributedLockServiceMXBean bean = null;
        final ManagementService service = ManagementTestBase.getManagementService();
        Wait.waitForCriterion(new WaitCriterion(){
            DistributedLockServiceMXBean bean = null;

            @Override
            public String description() {
                return "Waiting for " + expectedMembers + " proxies to get reflected at managing node";
            }

            @Override
            public boolean done() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                this.bean = service.getDistributedLockServiceMXBean(lockServiceName);
                boolean done = this.bean != null && this.bean.getMemberCount() == expectedMembers;
                return done;
            }
        }, 16000L, 500L, true);
        bean = service.getDistributedLockServiceMXBean(lockServiceName);
        return bean;
    }

    public static LocatorMXBean getLocatorMbeanProxy(DistributedMember member) throws Exception {
        LocatorMXBean bean;
        block2: {
            final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
            final ObjectName locatorMBeanName = service.getLocatorMBeanName(member);
            Wait.waitForCriterion(new WaitCriterion(){
                LocatorMXBean bean = null;

                @Override
                public String description() {
                    return "Waiting for the proxy to get reflected at managing node";
                }

                @Override
                public boolean done() {
                    GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                    this.bean = (LocatorMXBean)service.getMBeanProxy(locatorMBeanName, LocatorMXBean.class);
                    boolean done = this.bean != null;
                    return done;
                }
            }, 16000L, 500L, true);
            bean = null;
            try {
                bean = (LocatorMXBean)service.getMBeanProxy(locatorMBeanName, LocatorMXBean.class);
            }
            catch (ManagementException mgz) {
                if (bean != null) break block2;
                InternalDistributedSystem.getLogger().fine("Undesired Result :Locator MBean Proxy Should Not be Empty for : " + locatorMBeanName.getCanonicalName());
            }
        }
        return bean;
    }

    public static void printBeanDetails(ObjectName objName) throws Exception {
        MBeanAttributeInfo[] attributeInfos;
        MBeanInfo info = null;
        try {
            info = mbeanServer.getMBeanInfo(objName);
        }
        catch (IntrospectionException e1) {
            Assert.fail((String)"Could not obtain Sender Proxy Details");
        }
        catch (InstanceNotFoundException e1) {
            Assert.fail((String)"Could not obtain Sender Proxy Details");
        }
        catch (ReflectionException e1) {
            Assert.fail((String)"Could not obtain Sender Proxy Details");
        }
        for (MBeanAttributeInfo attributeInfo : attributeInfos = info.getAttributes()) {
            Object propertyValue = null;
            String propertyName = null;
            try {
                propertyName = attributeInfo.getName();
                propertyValue = mbeanServer.getAttribute(objName, propertyName);
                LogWriterUtils.getLogWriter().info("<ExpectedString> " + propertyName + " = " + propertyValue + "</ExpectedString> ");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

