/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.log4j;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.BreakIterator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.apache.geode.GemFireException;
import org.apache.geode.LogWriter;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.i18n.StringId;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;

public class LogWriterLogger
extends ExtendedLoggerWrapper
implements LogWriter,
LogWriterI18n {
    public static final String SECURITY_PREFIX = "security-";
    private final ExtendedLoggerWrapper logWrapper = this;
    private final String connectionName;
    private final String loggerName;
    private final boolean isSecure;
    private static final int ALL_LEVEL = Integer.MIN_VALUE;
    private static final int FINEST_LEVEL = 300;
    private static final int FINER_LEVEL = 400;
    private static final int FINE_LEVEL = 500;
    private static final int CONFIG_LEVEL = 700;
    private static final int INFO_LEVEL = 800;
    private static final int WARNING_LEVEL = 900;
    private static final int SEVERE_LEVEL = 1000;
    private static final int ERROR_LEVEL = 950;
    private static final int NONE_LEVEL = Integer.MAX_VALUE;
    private static final int LOGGING_FLAGS_MASK = 0xFFFFFF;
    private static final int SECURITY_LOGGING_FLAG = 0x40000000;

    private LogWriterLogger(Logger logger, String connectionName, boolean isSecure) {
        super((ExtendedLogger)((AbstractLogger)logger), logger.getName(), logger.getMessageFactory());
        this.connectionName = connectionName;
        this.loggerName = this.getName();
        this.isSecure = isSecure;
    }

    public static LogWriterLogger create(String name, boolean isSecure) {
        return LogWriterLogger.create(name, null, isSecure);
    }

    public static LogWriterLogger create(String name, String connectionName, boolean isSecure) {
        Logger wrapped = LogManager.getLogger((String)name);
        return new LogWriterLogger(wrapped, connectionName, isSecure);
    }

    public static LogWriterLogger create(Logger logger) {
        return new LogWriterLogger(logger, null, false);
    }

    public void finest(Marker marker, Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, null);
    }

    public void finest(Marker marker, Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, throwable);
    }

    public void finest(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, null);
    }

    public void finest(Marker marker, Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, throwable);
    }

    public void finest(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, (Throwable)null);
    }

    public void finest(Marker marker, String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, parameters);
    }

    public void finest(Marker marker, String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, throwable);
    }

    public void finest(Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, null);
    }

    public void finest(Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, throwable);
    }

    public void finest(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, null);
    }

    public void finest(Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, throwable);
    }

    public void finest(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, (Throwable)null);
    }

    public void finest(String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, parameters);
    }

    public void finest(String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, throwable);
    }

    public void finer(Marker marker, Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, null);
    }

    public void finer(Marker marker, Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, throwable);
    }

    public void finer(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, null);
    }

    public void finer(Marker marker, Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, throwable);
    }

    public void finer(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, (Throwable)null);
    }

    public void finer(Marker marker, String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, parameters);
    }

    public void finer(Marker marker, String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, throwable);
    }

    public void finer(Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, null);
    }

    public void finer(Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, throwable);
    }

    public void finer(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, null);
    }

    public void finer(Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, throwable);
    }

    public void finer(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, (Throwable)null);
    }

    private void finer(String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, parameters);
    }

    public void finer(String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, throwable);
    }

    public void fine(Marker marker, Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, null);
    }

    public void fine(Marker marker, Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, throwable);
    }

    public void fine(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, null);
    }

    public void fine(Marker marker, Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, throwable);
    }

    public void fine(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, (Throwable)null);
    }

    public void fine(Marker marker, String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, parameters);
    }

    public void fine(Marker marker, String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, throwable);
    }

    public void fine(Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, message, null);
    }

    public void fine(Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, message, throwable);
    }

    public void fine(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, message, null);
    }

    public void fine(Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, message, throwable);
    }

    public void fine(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, message, (Throwable)null);
    }

    public void fine(String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, message, parameters);
    }

    public void fine(String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, message, throwable);
    }

    public void config(Marker marker, Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, null);
    }

    public void config(Marker marker, Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, throwable);
    }

    public void config(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, null);
    }

    public void config(Marker marker, Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, throwable);
    }

    public void config(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, (Throwable)null);
    }

    public void config(Marker marker, String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, parameters);
    }

    public void config(Marker marker, String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, throwable);
    }

    public void config(Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, null);
    }

    public void config(Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, throwable);
    }

    public void config(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, null);
    }

    public void config(Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, throwable);
    }

    public void config(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, (Throwable)null);
    }

    public void config(String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, parameters);
    }

    public void config(String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, throwable);
    }

    public void info(Marker marker, Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, msg, null);
    }

    public void info(Marker marker, Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, msg, t);
    }

    public void info(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, null);
    }

    public void info(Marker marker, Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, t);
    }

    public void info(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, (Throwable)null);
    }

    public void info(Marker marker, String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, params);
    }

    public void info(Marker marker, String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, t);
    }

    public void info(Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, msg, null);
    }

    public void info(Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, msg, t);
    }

    public void info(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, null);
    }

    public void info(Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, t);
    }

    public void info(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, (Throwable)null);
    }

    public void info(String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, params);
    }

    public void info(String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, t);
    }

    public void warning(Marker marker, Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, null);
    }

    public void warning(Marker marker, Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, throwable);
    }

    public void warning(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, null);
    }

    public void warning(Marker marker, Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, throwable);
    }

    public void warning(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, (Throwable)null);
    }

    public void warning(Marker marker, String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, parameters);
    }

    public void warning(Marker marker, String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, throwable);
    }

    public void warning(Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, message, null);
    }

    public void warning(Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, message, throwable);
    }

    public void warning(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, message, null);
    }

    public void warning(Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, message, throwable);
    }

    public void warning(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, message, (Throwable)null);
    }

    public void warning(String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, message, parameters);
    }

    public void warning(String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, message, throwable);
    }

    public void error(Marker marker, Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, msg, null);
    }

    public void error(Marker marker, Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, msg, t);
    }

    public void error(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, message, null);
    }

    public void error(Marker marker, Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, message, t);
    }

    public void error(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, message, (Throwable)null);
    }

    public void error(Marker marker, String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, message, params);
    }

    public void error(Marker marker, String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, message, t);
    }

    public void error(Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, msg, null);
    }

    public void error(Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, msg, t);
    }

    public void error(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, message, null);
    }

    public void error(Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, message, t);
    }

    public void error(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, message, (Throwable)null);
    }

    public void error(String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, message, params);
    }

    public void error(String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, message, t);
    }

    public void severe(Marker marker, Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, null);
    }

    public void severe(Marker marker, Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, throwable);
    }

    public void severe(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, null);
    }

    public void severe(Marker marker, Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, throwable);
    }

    public void severe(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, (Throwable)null);
    }

    public void severe(Marker marker, String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, parameters);
    }

    public void severe(Marker marker, String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, throwable);
    }

    public void severe(Message message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, message, null);
    }

    public void severe(Message message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, message, throwable);
    }

    public void severe(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, message, null);
    }

    public void severe(Object message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, message, throwable);
    }

    public void severe(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, message, (Throwable)null);
    }

    public void severe(String message, Object ... parameters) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, message, parameters);
    }

    public void severe(String message, Throwable throwable) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, message, throwable);
    }

    public void log(int logWriterLevel, String message, Throwable throwable) {
        Level level = LogWriterLevelConverter.toLevel(LogWriterLevel.find(logWriterLevel));
        this.logWrapper.logIfEnabled(this.loggerName, level, null, message, throwable);
    }

    public boolean severeEnabled() {
        return this.isEnabled(Level.FATAL);
    }

    public boolean errorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    public boolean warningEnabled() {
        return this.isEnabled(Level.WARN);
    }

    public boolean infoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    public boolean configEnabled() {
        return this.isEnabled(Level.INFO);
    }

    public boolean fineEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    public boolean finerEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    public boolean finestEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    public void entering(String sourceClass, String sourceMethod) {
        this.finer("ENTRY {}:{}", sourceClass, sourceMethod);
    }

    public void exiting(String sourceClass, String sourceMethod) {
        this.finer("RETURN {}:{}", sourceClass, sourceMethod);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.finer("THROW {}:{}", sourceClass, sourceMethod, thrown);
    }

    public Handler getHandler() {
        return new GemFireHandler(this);
    }

    public LogWriterI18n convertToLogWriterI18n() {
        return this;
    }

    public void severe(Throwable throwable) {
        this.severe((String)null, throwable);
    }

    public void error(Throwable throwable) {
        this.error((String)null, throwable);
    }

    public void warning(Throwable throwable) {
        this.warning((String)null, throwable);
    }

    public void info(Throwable throwable) {
        this.info((String)null, throwable);
    }

    public void config(Throwable throwable) {
        this.config((String)null, throwable);
    }

    public void fine(Throwable throwable) {
        this.fine((String)null, throwable);
    }

    public void finer(Throwable throwable) {
        this.finer((String)null, throwable);
    }

    public void finest(Throwable throwable) {
        this.finest((String)null, throwable);
    }

    public void severe(StringId messageId, Object[] parameters, Throwable throwable) {
        if (this.isEnabled(Level.FATAL)) {
            this.severe(messageId.toLocalizedString(parameters), throwable);
        }
    }

    public void severe(StringId messageId, Object parameter, Throwable throwable) {
        if (this.isEnabled(Level.FATAL)) {
            this.severe(messageId.toLocalizedString(new Object[]{parameter}), throwable);
        }
    }

    public void severe(StringId messageId, Throwable throwable) {
        if (this.isEnabled(Level.FATAL)) {
            this.severe(messageId.toLocalizedString(), throwable);
        }
    }

    public void severe(StringId messageId, Object[] parameters) {
        if (this.isEnabled(Level.FATAL)) {
            this.severe(messageId.toLocalizedString(parameters));
        }
    }

    public void severe(StringId messageId, Object parameter) {
        if (this.isEnabled(Level.FATAL)) {
            this.severe(messageId.toLocalizedString(new Object[]{parameter}));
        }
    }

    public void severe(StringId messageId) {
        if (this.isEnabled(Level.FATAL)) {
            this.severe(messageId.toLocalizedString());
        }
    }

    public void error(StringId messageId, Object[] parameters, Throwable throwable) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(messageId.toLocalizedString(parameters), throwable);
        }
    }

    public void error(StringId messageId, Object parameter, Throwable throwable) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(messageId.toLocalizedString(new Object[]{parameter}), throwable);
        }
    }

    public void error(StringId messageId, Throwable throwable) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(messageId.toLocalizedString(), throwable);
        }
    }

    public void error(StringId messageId, Object[] parameters) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(messageId.toLocalizedString(parameters));
        }
    }

    public void error(StringId messageId, Object parameter) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(messageId.toLocalizedString(new Object[]{parameter}));
        }
    }

    public void error(StringId messageId) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(messageId.toLocalizedString());
        }
    }

    public void warning(StringId messageId, Object[] parameters, Throwable throwable) {
        if (this.isEnabled(Level.WARN)) {
            this.warning(messageId.toLocalizedString(parameters), throwable);
        }
    }

    public void warning(StringId messageId, Object parameter, Throwable throwable) {
        if (this.isEnabled(Level.WARN)) {
            this.warning(messageId.toLocalizedString(new Object[]{parameter}), throwable);
        }
    }

    public void warning(StringId messageId, Throwable throwable) {
        if (this.isEnabled(Level.WARN)) {
            this.warning(messageId.toLocalizedString(), throwable);
        }
    }

    public void warning(StringId messageId, Object[] parameters) {
        if (this.isEnabled(Level.WARN)) {
            this.warning(messageId.toLocalizedString(parameters));
        }
    }

    public void warning(StringId messageId, Object parameter) {
        if (this.isEnabled(Level.WARN)) {
            this.warning(messageId.toLocalizedString(new Object[]{parameter}));
        }
    }

    public void warning(StringId messageId) {
        if (this.isEnabled(Level.WARN)) {
            this.warning(messageId.toLocalizedString());
        }
    }

    public void info(StringId messageId, Object[] parameters, Throwable throwable) {
        if (this.isEnabled(Level.INFO)) {
            this.info(messageId.toLocalizedString(parameters), throwable);
        }
    }

    public void info(StringId messageId, Object parameter, Throwable throwable) {
        if (this.isEnabled(Level.INFO)) {
            this.info(messageId.toLocalizedString(new Object[]{parameter}), throwable);
        }
    }

    public void info(StringId messageId, Throwable throwable) {
        if (this.isEnabled(Level.INFO)) {
            this.info(messageId.toLocalizedString(), throwable);
        }
    }

    public void info(StringId messageId, Object[] parameters) {
        if (this.isEnabled(Level.INFO)) {
            this.info(messageId.toLocalizedString(parameters));
        }
    }

    public void info(StringId messageId, Object parameter) {
        if (this.isEnabled(Level.INFO)) {
            this.info(messageId.toLocalizedString(new Object[]{parameter}));
        }
    }

    public void info(StringId messageId) {
        if (this.isEnabled(Level.INFO)) {
            this.info(messageId.toLocalizedString());
        }
    }

    public void config(StringId messageId, Object[] parameters, Throwable throwable) {
        if (this.isEnabled(Level.INFO)) {
            this.config(messageId.toLocalizedString(parameters), throwable);
        }
    }

    public void config(StringId messageId, Object parameter, Throwable throwable) {
        if (this.isEnabled(Level.INFO)) {
            this.config(messageId.toLocalizedString(new Object[]{parameter}), throwable);
        }
    }

    public void config(StringId messageId, Throwable throwable) {
        if (this.isEnabled(Level.INFO)) {
            this.config(messageId.toLocalizedString(), throwable);
        }
    }

    public void config(StringId messageId, Object[] parameters) {
        if (this.isEnabled(Level.INFO)) {
            this.config(messageId.toLocalizedString(parameters));
        }
    }

    public void config(StringId messageId, Object parameter) {
        if (this.isEnabled(Level.INFO)) {
            this.config(messageId.toLocalizedString(new Object[]{parameter}));
        }
    }

    public void config(StringId messageId) {
        if (this.isEnabled(Level.INFO)) {
            this.config(messageId.toLocalizedString());
        }
    }

    public LogWriter convertToLogWriter() {
        return this;
    }

    public int getLogWriterLevel() {
        Level log4jLevel = this.logWrapper.getLevel();
        if (log4jLevel == Level.OFF) {
            return LogWriterLevel.NONE.intLevel();
        }
        if (log4jLevel == Level.FATAL) {
            return LogWriterLevel.SEVERE.intLevel();
        }
        if (log4jLevel == Level.ERROR) {
            return LogWriterLevel.ERROR.intLevel();
        }
        if (log4jLevel == Level.WARN) {
            return LogWriterLevel.WARNING.intLevel();
        }
        if (log4jLevel == Level.INFO) {
            return LogWriterLevel.INFO.intLevel();
        }
        if (log4jLevel == Level.DEBUG) {
            return LogWriterLevel.FINE.intLevel();
        }
        if (log4jLevel == Level.TRACE) {
            return LogWriterLevel.FINER.intLevel();
        }
        if (log4jLevel == Level.ALL) {
            return LogWriterLevel.ALL.intLevel();
        }
        throw new IllegalStateException("Level " + log4jLevel + " could not be mapped to LogWriter level.");
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void put(int messageLevel, String message, Throwable throwable) {
        this.log(messageLevel, message, throwable);
    }

    public void put(int messageLevel, StringId messageId, Object[] parameters, Throwable throwable) {
        this.log(messageLevel, messageId.toLocalizedString(parameters), throwable);
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public static String levelToString(int level) {
        switch (level) {
            case -2147483648: {
                return "all";
            }
            case 300: {
                return "finest";
            }
            case 400: {
                return "finer";
            }
            case 500: {
                return "fine";
            }
            case 700: {
                return "config";
            }
            case 800: {
                return "info";
            }
            case 900: {
                return "warning";
            }
            case 950: {
                return "error";
            }
            case 1000: {
                return "severe";
            }
            case 0x7FFFFFFF: {
                return "none";
            }
        }
        return LogWriterLogger.levelToStringSpecialCase(level);
    }

    private static String levelToStringSpecialCase(int levelWithFlags) {
        if ((levelWithFlags & 0x40000000) != 0) {
            int level = levelWithFlags ^ 0x40000000;
            return SECURITY_PREFIX + LogWriterLogger.levelToString(level);
        }
        return "level-" + levelWithFlags;
    }

    public static class GemFireFormatter
    extends Formatter {
        private final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS z");

        GemFireFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            pw.print('[');
            pw.print(record.getLevel().getName());
            pw.print(' ');
            pw.print(this.dateFormat.format(new Date(record.getMillis())));
            String threadName = Thread.currentThread().getName();
            if (threadName != null) {
                pw.print(' ');
                pw.print(threadName);
            }
            pw.print(" tid=0x");
            pw.print(Long.toHexString(Thread.currentThread().getId()));
            pw.print("] ");
            pw.print("(msgTID=");
            pw.print(record.getThreadID());
            pw.print(" msgSN=");
            pw.print(record.getSequenceNumber());
            pw.print(") ");
            String msg = record.getMessage();
            if (msg != null) {
                try {
                    GemFireFormatter.formatText(pw, msg, 40);
                }
                catch (RuntimeException e) {
                    pw.println(msg);
                    pw.println("Ignoring the following exception:");
                    e.printStackTrace(pw);
                }
            } else {
                pw.println();
            }
            if (record.getThrown() != null) {
                record.getThrown().printStackTrace(pw);
            }
            pw.close();
            try {
                sw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sw.toString();
        }

        private static void formatText(PrintWriter writer, String target, int initialLength) {
            BreakIterator boundary = BreakIterator.getLineInstance();
            boundary.setText(target);
            int start = boundary.first();
            int end = boundary.next();
            int lineLength = initialLength;
            while (end != -1) {
                char endChar = target.charAt(end - 1);
                while (!Character.isWhitespace(endChar)) {
                    int lastEnd = end;
                    end = boundary.next();
                    if (end == -1) {
                        end = lastEnd;
                        break;
                    }
                    endChar = target.charAt(end - 1);
                }
                int wordEnd = end;
                if (endChar == '\n') {
                    if (--wordEnd > 0 && target.charAt(wordEnd - 1) == '\r') {
                        --wordEnd;
                    }
                } else if (endChar == '\t') {
                    lineLength += 7;
                }
                String word = target.substring(start, wordEnd);
                lineLength += word.length();
                writer.print(word);
                if (endChar == '\n' || endChar == '\r') {
                    writer.println();
                    writer.print("  ");
                    lineLength = 2;
                }
                start = end;
                end = boundary.next();
            }
            if (lineLength != 0) {
                writer.println();
            }
        }
    }

    public static class GemFireHandler
    extends Handler {
        private LogWriter logWriter;

        private GemFireHandler(LogWriter logWriter) {
            this.logWriter = logWriter;
            this.setFormatter(new GemFireFormatter());
        }

        @Override
        public void close() {
            this.logWriter = null;
        }

        @Override
        public void flush() {
        }

        private String getMessage(LogRecord record) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('(').append("tid=").append(record.getThreadID()).append(" msgId=").append(record.getSequenceNumber()).append(") ");
            if (record.getMessage() != null) {
                stringBuilder.append(this.getFormatter().formatMessage(record));
            }
            return stringBuilder.toString();
        }

        @Override
        public void publish(LogRecord record) {
            if (this.isLoggable(record)) {
                try {
                    if (!(this.logWriter instanceof LogWriterLogger)) {
                        throw new UnsupportedOperationException("LogWriterLogger (geode-dunit) does not support LogWriterImpl");
                    }
                    ((LogWriterLogger)this.logWriter).log(record.getLevel().intValue(), this.getMessage(record), record.getThrown());
                }
                catch (GemFireException ex) {
                    this.reportError(null, (Exception)((Object)ex), 1);
                }
            }
        }
    }

    public static class LogWriterLevelConverter {
        public static Level toLevel(LogWriterLevel logWriterLevel) {
            switch (logWriterLevel) {
                case ALL: {
                    return Level.ALL;
                }
                case SEVERE: {
                    return Level.FATAL;
                }
                case ERROR: {
                    return Level.ERROR;
                }
                case WARNING: {
                    return Level.WARN;
                }
                case INFO: {
                    return Level.INFO;
                }
                case CONFIG: {
                    return Level.INFO;
                }
                case FINE: {
                    return Level.DEBUG;
                }
                case FINER: {
                    return Level.TRACE;
                }
                case FINEST: {
                    return Level.TRACE;
                }
                case NONE: {
                    return Level.OFF;
                }
            }
            throw new IllegalArgumentException("No matching Log4J2 Level for " + (Object)((Object)logWriterLevel) + ".");
        }

        public LogWriterLevel fromLevel(Level level) {
            if (level == Level.ALL) {
                return LogWriterLevel.ALL;
            }
            if (level == Level.FATAL) {
                return LogWriterLevel.SEVERE;
            }
            if (level == Level.ERROR) {
                return LogWriterLevel.ERROR;
            }
            if (level == Level.WARN) {
                return LogWriterLevel.WARNING;
            }
            if (level == Level.INFO) {
                return LogWriterLevel.INFO;
            }
            if (level == Level.DEBUG) {
                return LogWriterLevel.FINE;
            }
            if (level == Level.TRACE) {
                return LogWriterLevel.FINEST;
            }
            if (level == Level.OFF) {
                return LogWriterLevel.NONE;
            }
            throw new IllegalArgumentException("No matching AlertLevel for Log4J2 Level " + level + ".");
        }
    }

    public static enum LogWriterLevel {
        ALL(Integer.MIN_VALUE),
        FINEST(300),
        FINER(400),
        FINE(500),
        CONFIG(700),
        INFO(800),
        WARNING(900),
        ERROR(950),
        SEVERE(1000),
        NONE(Integer.MAX_VALUE);

        private final int intLevel;

        public static LogWriterLevel find(int intLevel) {
            for (LogWriterLevel logWriterLevel : LogWriterLevel.values()) {
                if (logWriterLevel.intLevel != intLevel) continue;
                return logWriterLevel;
            }
            throw new IllegalArgumentException("No LogWriterLevel found for intLevel " + intLevel);
        }

        private LogWriterLevel(int intLevel) {
            this.intLevel = intLevel;
        }

        public int intLevel() {
            return this.intLevel;
        }
    }
}

