/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.internal;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.VMEventListener;
import org.apache.geode.test.dunit.VMEventListenerRegistry;

public class VMEventNotifier
implements VMEventListenerRegistry {
    private final List<VMEventListener> listeners = new CopyOnWriteArrayList<VMEventListener>();

    VMEventNotifier() {
    }

    @Override
    public void addVMEventListener(VMEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeVMEventListener(VMEventListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyAfterCreateVM(VM vm) {
        for (VMEventListener listener : this.listeners) {
            listener.afterCreateVM(vm);
        }
    }

    public void notifyBeforeBounceVM(VM vm) {
        for (VMEventListener listener : this.listeners) {
            listener.beforeBounceVM(vm);
        }
    }

    public void notifyAfterBounceVM(VM vm) {
        for (VMEventListener listener : this.listeners) {
            listener.afterBounceVM(vm);
        }
    }
}

