/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms;

import org.apache.geode.CancelException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.MembershipManager;
import org.apache.geode.distributed.internal.membership.MembershipTestHook;
import org.apache.geode.distributed.internal.membership.adapter.GMSMembershipManager;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.dunit.WaitCriterion;
import org.awaitility.core.ThrowingRunnable;

public class MembershipManagerHelper {
    public static MembershipManager getMembership(DistributedSystem sys) {
        InternalDistributedSystem isys = (InternalDistributedSystem)sys;
        ClusterDistributionManager dm = (ClusterDistributionManager)isys.getDM();
        return dm.getMembershipManager();
    }

    public static void beSickMember(DistributedSystem sys) {
        MembershipManagerHelper.getMembership(sys).beSick();
    }

    public static void playDead(DistributedSystem sys) {
        try {
            MembershipManagerHelper.getMembership(sys).playDead();
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    public static DistributedMember getCoordinator(DistributedSystem sys) {
        return MembershipManagerHelper.getMembership(sys).getView().getCoordinator();
    }

    public static DistributedMember getLeadMember(DistributedSystem sys) {
        return MembershipManagerHelper.getMembership(sys).getView().getLeadMember();
    }

    public static void addTestHook(DistributedSystem sys, MembershipTestHook hook) {
        MembershipManagerHelper.getMembership(sys).registerTestHook(hook);
    }

    public static void removeTestHook(DistributedSystem sys, MembershipTestHook hook) {
        MembershipManagerHelper.getMembership(sys).unregisterTestHook(hook);
    }

    public static void addSurpriseMember(DistributedSystem sys, DistributedMember mbr, long birthTime) {
        MembershipManagerHelper.getMembership(sys).addSurpriseMemberForTesting(mbr, birthTime);
    }

    public static void inhibitForcedDisconnectLogging(boolean b) {
        GMSMembershipManager.inhibitForcedDisconnectLogging((boolean)b);
    }

    public static void waitForMemberDeparture(final DistributedSystem sys, final DistributedMember member, final long timeout) {
        WaitCriterion ev = new WaitCriterion(){

            @Override
            public boolean done() {
                return !MembershipManagerHelper.getMembership(sys).getView().contains(member);
            }

            @Override
            public String description() {
                return "Waited over " + timeout + " ms for " + member + " to depart, but it didn't";
            }
        };
        GeodeAwaitility.await().untilAsserted((ThrowingRunnable)ev);
    }

    @VisibleForTesting
    public static void crashDistributedSystem(DistributedSystem msys) {
        msys.getLogWriter().info("crashing distributed system: " + msys);
        GMSMembershipManager mgr = (GMSMembershipManager)MembershipManagerHelper.getMembership(msys);
        MembershipManagerHelper.inhibitForcedDisconnectLogging(true);
        MembershipManagerHelper.beSickMember(msys);
        MembershipManagerHelper.playDead(msys);
        mgr.getGMSManager().forceDisconnect("for testing");
        GeodeAwaitility.await().until(() -> !msys.isConnected());
        MembershipManagerHelper.inhibitForcedDisconnectLogging(false);
    }
}

