/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.util.concurrent.TimeUnit;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.dunit.DUnitBlackboard;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.internal.JUnit4DistributedTestCase;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.junit.rules.Locator;
import org.apache.geode.test.junit.rules.Member;
import org.apache.geode.test.junit.rules.Server;
import org.apache.geode.test.junit.rules.VMProvider;
import org.apache.logging.log4j.Logger;

public class MemberVM
extends VMProvider
implements Member {
    private static Logger logger = LogService.getLogger();
    protected Member member;
    protected VM vm;

    public MemberVM(Member member, VM vm) {
        this.member = member;
        this.vm = vm;
    }

    @Override
    public boolean isLocator() {
        return this.member instanceof Locator;
    }

    @Override
    public VM getVM() {
        return this.vm;
    }

    public Member getMember() {
        return this.member;
    }

    @Override
    public int getPort() {
        return this.member.getPort();
    }

    @Override
    public int getJmxPort() {
        return this.member.getJmxPort();
    }

    @Override
    public int getHttpPort() {
        return this.member.getHttpPort();
    }

    @Override
    public String getName() {
        return this.member.getName();
    }

    public int getEmbeddedLocatorPort() {
        if (!(this.member instanceof Server)) {
            throw new RuntimeException("member needs to be a server");
        }
        return ((Server)this.member).getEmbeddedLocatorPort();
    }

    public void forceDisconnect() {
        this.vm.invoke("force disconnect", () -> ClusterStartupRule.memberStarter.forceDisconnectMember());
    }

    public void forceDisconnect(final long timeout, final TimeUnit timeUnit, final String reconnectBBKey) {
        this.vm.invoke(() -> {
            final DUnitBlackboard server1BB = JUnit4DistributedTestCase.getBlackboard();
            server1BB.initBlackboard();
            server1BB.setMailbox(reconnectBBKey, false);
            InternalDistributedSystem.addReconnectListener((InternalDistributedSystem.ReconnectListener)new InternalDistributedSystem.ReconnectListener(){

                public void reconnecting(InternalDistributedSystem oldSystem) {
                    GeodeAwaitility.await().atMost(timeout, timeUnit).until(() -> (boolean)((Boolean)server1BB.getMailbox(reconnectBBKey)));
                }

                public void onReconnect(InternalDistributedSystem oldSystem, InternalDistributedSystem newSystem) {
                }
            });
            ClusterStartupRule.memberStarter.forceDisconnectMember();
        });
    }

    public void waitTilFullyReconnected() {
        this.vm.invoke(() -> ClusterStartupRule.memberStarter.waitTilFullyReconnected());
    }

    public void waitUntilRegionIsReadyOnExactlyThisManyServers(String regionPath, int serverCount) {
        this.vm.invoke(() -> ClusterStartupRule.memberStarter.waitUntilRegionIsReadyOnExactlyThisManyServers(regionPath, serverCount));
    }

    public void waitTillClientsAreReadyOnServers(String serverName, int serverPort, int clientCount) {
        this.vm.invoke(() -> ClusterStartupRule.memberStarter.waitTillClientsAreReadyOnServer(serverName, serverPort, clientCount));
    }

    public void waitUntilDiskStoreIsReadyOnExactlyThisManyServers(String diskstoreName, int serverCount) {
        this.vm.invoke(() -> ClusterStartupRule.memberStarter.waitUntilDiskStoreIsReadyOnExactlyThisManyServers(diskstoreName, serverCount));
    }

    public void waitUntilAsyncEventQueuesAreReadyOnExactlyThisManyServers(String queueId, int serverCount) {
        this.vm.invoke(() -> ClusterStartupRule.memberStarter.waitUntilAsyncEventQueuesAreReadyOnExactlyThisManyServers(queueId, serverCount));
    }

    public void waitTillCacheClientProxyHasBeenPaused() {
        this.vm.invoke(() -> ClusterStartupRule.memberStarter.waitTillCacheClientProxyHasBeenPaused());
    }
}

