/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.cq.internal.ops;

import java.util.List;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.cache.client.internal.ServerProxy;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.cq.internal.ops.CloseCQOp;
import org.apache.geode.cache.query.cq.internal.ops.CreateCQOp;
import org.apache.geode.cache.query.cq.internal.ops.CreateCQWithIROp;
import org.apache.geode.cache.query.cq.internal.ops.GetDurableCQsOp;
import org.apache.geode.cache.query.cq.internal.ops.StopCQOp;
import org.apache.geode.cache.query.internal.cq.ClientCQ;
import org.apache.geode.cache.query.internal.cq.InternalCqQuery;

public class ServerCQProxyImpl
extends ServerProxy {
    public ServerCQProxyImpl(InternalPool pool) {
        super(pool);
    }

    public ServerCQProxyImpl(ServerProxy sp) {
        this(sp.getPool());
    }

    public Object create(ClientCQ cq) {
        this.pool.getRITracker().addCq((InternalCqQuery)cq, cq.isDurable());
        byte regionDataPolicyOrdinal = cq.getCqBaseRegion() == null ? (byte)0 : cq.getCqBaseRegion().getAttributes().getDataPolicy().ordinal;
        return CreateCQOp.execute((ExecutablePool)this.pool, cq.getName(), cq.getQueryString(), 1, cq.isDurable(), regionDataPolicyOrdinal);
    }

    public void createOn(String cqName, Connection conn, String queryStr, int cqState, boolean isDurable, byte regionDataPolicy) {
        CreateCQOp.executeOn((ExecutablePool)this.pool, conn, cqName, queryStr, cqState, isDurable, regionDataPolicy);
    }

    public SelectResults createWithIR(ClientCQ cq) {
        this.pool.getRITracker().addCq((InternalCqQuery)cq, cq.isDurable());
        byte regionDataPolicyOrdinal = cq.getCqBaseRegion() == null ? (byte)0 : cq.getCqBaseRegion().getAttributes().getDataPolicy().ordinal;
        return CreateCQWithIROp.execute((ExecutablePool)this.pool, cq.getName(), cq.getQueryString(), 1, cq.isDurable(), regionDataPolicyOrdinal);
    }

    public void stop(ClientCQ cq) {
        this.pool.getRITracker().removeCq((InternalCqQuery)cq);
        StopCQOp.execute((ExecutablePool)this.pool, cq.getName());
    }

    public void close(ClientCQ cq) {
        this.pool.getRITracker().removeCq((InternalCqQuery)cq);
        CloseCQOp.execute((ExecutablePool)this.pool, cq.getName());
    }

    public List<String> getAllDurableCqsFromServer() {
        return GetDurableCQsOp.execute((ExecutablePool)this.pool);
    }
}

