/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.cq.internal.ops;

import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.cache.client.internal.QueryOp;
import org.apache.geode.cache.query.SelectResults;

public class CreateCQWithIROp {
    public static SelectResults execute(ExecutablePool pool, String cqName, String queryStr, int cqState, boolean isDurable, byte regionDataPolicy) {
        CreateCQWithIROpImpl op = new CreateCQWithIROpImpl(cqName, queryStr, cqState, isDurable, regionDataPolicy);
        return (SelectResults)pool.executeOnQueuesAndReturnPrimaryResult((Op)op);
    }

    private CreateCQWithIROp() {
    }

    private static class CreateCQWithIROpImpl
    extends QueryOp.QueryOpImpl {
        public CreateCQWithIROpImpl(String cqName, String queryStr, int cqState, boolean isDurable, byte regionDataPolicy) {
            super(43, 5);
            this.getMessage().addStringPart(cqName);
            this.getMessage().addStringPart(queryStr);
            this.getMessage().addIntPart(cqState);
            byte durableByte = (byte)(isDurable ? 1 : 0);
            this.getMessage().addBytesPart(new byte[]{durableByte});
            this.getMessage().addBytesPart(new byte[]{regionDataPolicy});
        }

        protected String getOpName() {
            return "createCQfetchInitialResult";
        }

        protected long startAttempt(ConnectionStats stats) {
            return stats.startCreateCQ();
        }

        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endCreateCQSend(start, this.hasFailed());
        }

        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endCreateCQ(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

