/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.JndiBindingsType;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.commands.CreateJndiBindingCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;

@Experimental
public class ListDataSourceCommand
extends GfshCommand {
    static final String LIST_DATA_SOURCE = "list data-source";
    private static final String LIST_DATA_SOURCE__HELP = "(Experimental) List each existing data source.";
    static final String DATA_SOURCE_PROPERTIES_SECTION = "data-source-properties";

    @ShellMethod(value="(Experimental) List each existing data source.", key={"list data-source"})
    @CliMetaData
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel listDataSources() {
        ResultModel resultModel = new ResultModel();
        resultModel.setHeader("(Experimental) ");
        TabularResultModel tabularData = resultModel.addTable(DATA_SOURCE_PROPERTIES_SECTION);
        tabularData.setColumnHeader(new String[]{"name", "pooled", "in use", "url"});
        ConfigurationPersistenceService ccService = this.getConfigurationPersistenceService();
        if (ccService == null) {
            return ResultModel.createError((String)"Cluster configuration service must be enabled.");
        }
        CacheConfig cacheConfig = ccService.getCacheConfig(null);
        if (cacheConfig == null) {
            return ResultModel.createInfo((String)"No data sources found");
        }
        cacheConfig.getJndiBindings().stream().forEach(dataSource -> this.addDataSourceToResult((JndiBindingsType.JndiBinding)dataSource, cacheConfig, tabularData));
        return resultModel;
    }

    private void addDataSourceToResult(JndiBindingsType.JndiBinding binding, CacheConfig cacheConfig, TabularResultModel tabularData) {
        boolean pooled;
        String type = binding.getType();
        if (CreateJndiBindingCommand.DATASOURCE_TYPE.SIMPLE.getType().equals(type)) {
            pooled = false;
        } else if (CreateJndiBindingCommand.DATASOURCE_TYPE.POOLED.getType().equals(type)) {
            pooled = true;
        } else {
            return;
        }
        String dataSourceName = binding.getJndiName();
        tabularData.addRow(new String[]{dataSourceName, Boolean.toString(pooled), Boolean.toString(this.isDataSourceUsedByRegion(cacheConfig, dataSourceName)), binding.getConnectionUrl()});
    }

    boolean isDataSourceUsedByRegion(CacheConfig cacheConfig, String dataSourceName) {
        return cacheConfig.getRegions().stream().anyMatch(regionConfig -> this.hasJdbcMappingThatUsesDataSource((RegionConfig)regionConfig, dataSourceName));
    }

    private boolean hasJdbcMappingThatUsesDataSource(RegionConfig regionConfig, String dataSourceName) {
        return regionConfig.getCustomRegionElements().stream().anyMatch(cacheElement -> this.isRegionMappingUsingDataSource((CacheElement)cacheElement, dataSourceName));
    }

    private boolean isRegionMappingUsingDataSource(CacheElement cacheElement, String dataSourceName) {
        if (!(cacheElement instanceof RegionMapping)) {
            return false;
        }
        RegionMapping regionMapping = (RegionMapping)cacheElement;
        return dataSourceName.equals(regionMapping.getDataSourceName());
    }

    @ShellMethodAvailability(value={"list data-source"})
    public boolean commandAvailable() {
        return this.isOnlineCommandAvailable();
    }
}

