/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.RegionAttributesType;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.connectors.jdbc.JdbcLoader;
import org.apache.geode.connectors.jdbc.JdbcWriter;
import org.apache.geode.connectors.jdbc.internal.cli.DestroyMappingFunction;
import org.apache.geode.connectors.jdbc.internal.cli.MappingCommandUtils;
import org.apache.geode.connectors.jdbc.internal.cli.PreconditionException;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;
import org.springframework.shell.standard.ShellOption;

@Experimental
public class DestroyMappingCommand
extends SingleGfshCommand {
    static final String DESTROY_MAPPING = "destroy jdbc-mapping";
    private static final String DESTROY_MAPPING__HELP = "(Experimental) Destroy the specified JDBC mapping.";
    private static final String DESTROY_MAPPING__REGION_NAME = "region";
    private static final String DESTROY_MAPPING__REGION_NAME__HELP = "Name of the region whose JDBC mapping will be destroyed.";
    private static final String DESTROY_MAPPING__GROUPS_NAME__HELP = "Server Group(s) of the JDBC mapping to be destroyed.";

    @ShellMethod(value="(Experimental) Destroy the specified JDBC mapping.", key={"destroy jdbc-mapping"})
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel destroyMapping(@ShellOption(value={"region"}, help="Name of the region whose JDBC mapping will be destroyed.") String regionName, @ShellOption(value={"group", "groups"}, defaultValue="__NULL__", help="Server Group(s) of the JDBC mapping to be destroyed.") String[] groups) {
        if (regionName.startsWith("/")) {
            regionName = regionName.substring(1);
        }
        Set targetMembers = this.findMembers(groups, null);
        try {
            ResultModel result;
            boolean isMappingInClusterConfig = false;
            ConfigurationPersistenceService configService = this.checkForClusterConfiguration();
            if (groups == null) {
                groups = new String[]{"cluster"};
            }
            for (String group : groups) {
                CacheConfig cacheConfig = this.getCacheConfig(configService, group);
                if (cacheConfig == null) continue;
                for (RegionConfig regionConfig : cacheConfig.getRegions()) {
                    if (regionConfig == null || MappingCommandUtils.getMappingsFromRegionConfig(cacheConfig, regionConfig, group).isEmpty()) continue;
                    isMappingInClusterConfig = true;
                }
            }
            if (!isMappingInClusterConfig) {
                return ResultModel.createError((String)"Mapping not found in cluster configuration.");
            }
            if (targetMembers != null) {
                List results = this.executeAndGetFunctionResult((Function)new DestroyMappingFunction(), regionName, targetMembers);
                result = ResultModel.createMemberStatusResult((List)results, (String)"(Experimental) ", null, (boolean)false, (boolean)true);
            } else {
                result = ResultModel.createInfo((String)("No members found in specified server groups containing a mapping for region \"" + regionName + "\""));
            }
            result.setConfigObject((Object)regionName);
            return result;
        }
        catch (PreconditionException ex) {
            return ResultModel.createError((String)ex.getMessage());
        }
    }

    public boolean updateConfigForGroup(String group, CacheConfig cacheConfig, Object configObject) {
        String regionName = (String)configObject;
        RegionConfig regionConfig = this.findRegionConfig(cacheConfig, regionName);
        if (regionConfig == null) {
            return false;
        }
        boolean modified = false;
        modified |= this.removeJdbcMappingFromRegion(regionConfig);
        modified |= this.removeJdbcQueueFromCache(cacheConfig, regionName);
        RegionAttributesType attributes = this.getRegionAttribute(regionConfig);
        modified |= this.removeJdbcLoader(attributes);
        modified |= this.removeJdbcWriter(attributes);
        return modified |= this.removeJdbcAsyncEventQueueId(attributes, regionName);
    }

    private RegionAttributesType getRegionAttribute(RegionConfig config) {
        if (config.getRegionAttributes() == null) {
            config.setRegionAttributes(new RegionAttributesType());
        }
        return config.getRegionAttributes();
    }

    private boolean removeJdbcLoader(RegionAttributesType attributes) {
        DeclarableType cacheLoader = attributes.getCacheLoader();
        if (cacheLoader != null && JdbcLoader.class.getName().equals(cacheLoader.getClassName())) {
            attributes.setCacheLoader(null);
            return true;
        }
        return false;
    }

    private boolean removeJdbcWriter(RegionAttributesType attributes) {
        DeclarableType cacheWriter = attributes.getCacheWriter();
        if (cacheWriter != null && JdbcWriter.class.getName().equals(cacheWriter.getClassName())) {
            attributes.setCacheWriter(null);
            return true;
        }
        return false;
    }

    private boolean removeJdbcAsyncEventQueueId(RegionAttributesType attributes, String regionName) {
        String queueName = MappingCommandUtils.createAsyncEventQueueName(regionName);
        String queueIds = attributes.getAsyncEventQueueIds();
        if (queueIds == null) {
            return false;
        }
        ArrayList<String> queues = new ArrayList<String>(Arrays.asList(queueIds.split(",")));
        if (queues.contains(queueName)) {
            queues.remove(queueName);
            String newQueueIds = String.join((CharSequence)",", queues);
            attributes.setAsyncEventQueueIds(newQueueIds);
            return true;
        }
        return false;
    }

    private boolean removeJdbcQueueFromCache(CacheConfig cacheConfig, String regionName) {
        String queueName = MappingCommandUtils.createAsyncEventQueueName(regionName);
        Iterator iterator = cacheConfig.getAsyncEventQueues().iterator();
        while (iterator.hasNext()) {
            CacheConfig.AsyncEventQueue queue = (CacheConfig.AsyncEventQueue)iterator.next();
            if (!queueName.equals(queue.getId())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    private boolean removeJdbcMappingFromRegion(RegionConfig regionConfig) {
        Iterator iterator = regionConfig.getCustomRegionElements().iterator();
        while (iterator.hasNext()) {
            CacheElement element = (CacheElement)iterator.next();
            if (!(element instanceof RegionMapping)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    private RegionConfig findRegionConfig(CacheConfig cacheConfig, String regionName) {
        return cacheConfig.getRegions().stream().filter(region -> region.getName().equals(regionName)).findFirst().orElse(null);
    }

    private CacheConfig getCacheConfig(ConfigurationPersistenceService configService, String group) throws PreconditionException {
        CacheConfig result = configService.getCacheConfig(group);
        return result;
    }

    protected ConfigurationPersistenceService checkForClusterConfiguration() throws PreconditionException {
        ConfigurationPersistenceService result = this.getConfigurationPersistenceService();
        if (result == null) {
            throw new PreconditionException("Cluster Configuration must be enabled.");
        }
        return result;
    }

    @ShellMethodAvailability(value={"destroy jdbc-mapping"})
    public boolean commandAvailable() {
        return this.isOnlineCommandAvailable();
    }
}

