/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.JndiBindingsType;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.lang.Identifiable;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.commands.CreateJndiBindingCommand;
import org.apache.geode.management.internal.cli.functions.DestroyJndiBindingFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;
import org.springframework.shell.standard.ShellOption;

public class DestroyDataSourceCommand
extends SingleGfshCommand {
    static final String DESTROY_DATA_SOURCE = "destroy data-source";
    static final String DESTROY_DATA_SOURCE_HELP = "Destroy a data source that holds a jdbc configuration.";
    static final String DATA_SOURCE_NAME = "name";
    static final String DATA_SOURCE_NAME_HELP = "Name of the data source to be destroyed.";
    static final String IFEXISTS_HELP = "Skip the destroy operation when the specified data source does not exist. Without this option, an error results from the specification of a data source that does not exist.";

    @ShellMethod(value="Destroy a data source that holds a jdbc configuration.", key={"destroy data-source"})
    @CliMetaData(relatedTopic={"Region"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel destroyDataSource(@ShellOption(value={"name"}, help="Name of the data source to be destroyed.") String dataSourceName, @ShellOption(value={"if-exists"}, defaultValue="false", arity=0, help="Skip the destroy operation when the specified data source does not exist. Without this option, an error results from the specification of a data source that does not exist.") boolean ifExists) {
        Set targetMembers;
        InternalConfigurationPersistenceService service = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        if (service != null) {
            List bindings = service.getCacheConfig("cluster").getJndiBindings();
            JndiBindingsType.JndiBinding binding = (JndiBindingsType.JndiBinding)Identifiable.find((List)bindings, (String)dataSourceName);
            if (binding == null) {
                throw new EntityNotFoundException(CliStrings.format((String)"Data source named \"{0}\" does not exist.", (Object)dataSourceName), ifExists);
            }
            if (!this.isDataSource(binding)) {
                return ResultModel.createError((String)CliStrings.format((String)"Data source named \"{0}\" does not exist. A jndi-binding was found with that name.", (Object)dataSourceName));
            }
            try {
                this.checkIfDataSourceIsInUse(service, dataSourceName);
            }
            catch (IllegalStateException ex) {
                return ResultModel.createError((String)CliStrings.format((String)"Data source named \"{0}\" is still being used by region \"{1}\". Use destroy jdbc-mapping --region={1} and then try again.", (Object[])new Object[]{dataSourceName, ex.getMessage()}));
            }
        }
        if ((targetMembers = this.findMembers(null, null)).size() > 0) {
            List dataSourceDestroyResult = this.executeAndGetFunctionResult((Function)new DestroyJndiBindingFunction(), new Object[]{dataSourceName, true}, targetMembers);
            if (!ifExists) {
                int resultsNotFound = 0;
                for (CliFunctionResult result : dataSourceDestroyResult) {
                    if (!result.getStatusMessage().contains("not found")) continue;
                    ++resultsNotFound;
                }
                if (resultsNotFound == dataSourceDestroyResult.size()) {
                    throw new EntityNotFoundException(CliStrings.format((String)"Data source named \"{0}\" does not exist.", (Object)dataSourceName), ifExists);
                }
            }
            ResultModel result = ResultModel.createMemberStatusResult((List)dataSourceDestroyResult);
            result.setConfigObject((Object)dataSourceName);
            return result;
        }
        if (service != null) {
            ResultModel result = ResultModel.createInfo((String)"No members found, data source removed from cluster configuration.");
            result.setConfigObject((Object)dataSourceName);
            return result;
        }
        return ResultModel.createError((String)"No members found and cluster configuration disabled.");
    }

    private void checkIfDataSourceIsInUse(InternalConfigurationPersistenceService service, String dataSourceName) {
        CacheConfig cacheConfig = service.getCacheConfig(null);
        for (RegionConfig regionConfig : cacheConfig.getRegions()) {
            for (CacheElement cacheElement : regionConfig.getCustomRegionElements()) {
                RegionMapping regionMapping;
                if (!(cacheElement instanceof RegionMapping) || !dataSourceName.equals((regionMapping = (RegionMapping)cacheElement).getDataSourceName())) continue;
                throw new IllegalStateException(regionConfig.getName());
            }
        }
    }

    private boolean isDataSource(JndiBindingsType.JndiBinding binding) {
        return CreateJndiBindingCommand.DATASOURCE_TYPE.SIMPLE.getType().equals(binding.getType()) || CreateJndiBindingCommand.DATASOURCE_TYPE.POOLED.getType().equals(binding.getType());
    }

    public boolean updateConfigForGroup(String group, CacheConfig config, Object element) {
        Identifiable.remove((List)config.getJndiBindings(), (String)((String)element));
        return true;
    }

    @ShellMethodAvailability(value={"destroy data-source"})
    public boolean commandAvailable() {
        return this.isOnlineCommandAvailable();
    }
}

