/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.JndiBindingsType;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.connectors.jdbc.internal.cli.DeregisterDriverFunction;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@Experimental
public class DeregisterDriverCommand
extends GfshCommand {
    static final String DEREGISTER_DRIVER = "deregister driver";
    static final String DEREGISTER_DRIVER__HELP = "(Experimental) Deregister a driver with the cluster's Driver Manager using the name of a driver class contained within a currenly deployed jar.";
    static final String DRIVER_CLASS_NAME = "driver-class";
    static final String DRIVER_CLASS_NAME_HELP = "The name of the driver class contained in a currently deployed jar to be deregistered with the cluster's Driver Manager.";

    @ShellMethod(value="(Experimental) Deregister a driver with the cluster's Driver Manager using the name of a driver class contained within a currenly deployed jar.", key={"deregister driver"})
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel deregisterDriver(@ShellOption(value={"driver-class"}, help="The name of the driver class contained in a currently deployed jar to be deregistered with the cluster's Driver Manager.") String driverClassName) {
        try {
            Set targetMembers;
            ConfigurationPersistenceService ccService = this.getConfigurationPersistenceService();
            if (ccService == null) {
                return ResultModel.createError((String)"Cluster configuration service must be enabled.");
            }
            CacheConfig cacheConfig = ccService.getCacheConfig(null);
            if (cacheConfig != null) {
                for (JndiBindingsType.JndiBinding dataSource : cacheConfig.getJndiBindings()) {
                    if (!driverClassName.equals(dataSource.getJdbcDriverClass())) continue;
                    return ResultModel.createError((String)("Driver is currently in use by " + dataSource.getJndiName()));
                }
            }
            if ((targetMembers = this.findMembers(null, null)).size() > 0) {
                Object[] arguments = new Object[]{driverClassName};
                List deregisterDriverResults = this.executeAndGetFunctionResult((Function)new DeregisterDriverFunction(), arguments, targetMembers);
                return ResultModel.createMemberStatusResult((List)deregisterDriverResults, (String)"(Experimental) ", null, (boolean)false, (boolean)true);
            }
            return ResultModel.createInfo((String)"(Experimental) \nNo members found");
        }
        catch (Exception ex) {
            return ResultModel.createError((String)("Failed to deregister driver \"" + driverClassName + "\": " + ex.getMessage()));
        }
    }
}

