/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.connectors.jdbc.JdbcConnectorException;
import org.apache.geode.connectors.jdbc.internal.TableMetaData;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataView;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.internal.lang.utils.JavaWorkarounds;

public class TableMetaDataManager {
    private static final String DEFAULT_CATALOG = "";
    private static final String DEFAULT_SCHEMA = "";
    private final ConcurrentMap<String, TableMetaDataView> tableToMetaDataMap = new ConcurrentHashMap<String, TableMetaDataView>();

    public TableMetaDataView getTableMetaDataView(Connection connection, RegionMapping regionMapping) {
        return (TableMetaDataView)JavaWorkarounds.computeIfAbsent(this.tableToMetaDataMap, (Object)this.computeTableName(regionMapping), k -> this.computeTableMetaDataView(connection, (String)k, regionMapping));
    }

    String computeTableName(RegionMapping regionMapping) {
        String result = regionMapping.getTableName();
        if (result == null) {
            result = regionMapping.getRegionName();
        }
        return result;
    }

    private TableMetaDataView computeTableMetaDataView(Connection connection, String tableName, RegionMapping regionMapping) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String realCatalogName = this.getCatalogNameFromMetaData(metaData, regionMapping);
            String realSchemaName = this.getSchemaNameFromMetaData(metaData, regionMapping, realCatalogName);
            String realTableName = this.getTableNameFromMetaData(metaData, realCatalogName, realSchemaName, tableName);
            List<String> keys = this.getPrimaryKeyColumnNamesFromMetaData(metaData, realCatalogName, realSchemaName, realTableName, regionMapping.getIds());
            String quoteString = metaData.getIdentifierQuoteString();
            Map<String, TableMetaData.ColumnMetaData> columnMetaDataMap = this.createColumnMetaDataMap(metaData, realCatalogName, realSchemaName, realTableName);
            return new TableMetaData(realCatalogName, realSchemaName, realTableName, keys, quoteString, columnMetaDataMap);
        }
        catch (SQLException e) {
            throw JdbcConnectorException.createException(e);
        }
    }

    String getCatalogNameFromMetaData(DatabaseMetaData metaData, RegionMapping regionMapping) throws SQLException {
        String catalogFilter = regionMapping.getCatalog();
        if (catalogFilter == null || catalogFilter.isEmpty()) {
            return "";
        }
        try (ResultSet catalogs = metaData.getCatalogs();){
            String string = this.findMatchInResultSet(catalogFilter, catalogs, "TABLE_CAT", "catalog");
            return string;
        }
    }

    String getSchemaNameFromMetaData(DatabaseMetaData metaData, RegionMapping regionMapping, String catalogFilter) throws SQLException {
        String schemaFilter = regionMapping.getSchema();
        if (schemaFilter == null || schemaFilter.isEmpty()) {
            if ("PostgreSQL".equals(metaData.getDatabaseProductName())) {
                schemaFilter = "public";
            } else {
                return "";
            }
        }
        try (ResultSet schemas = metaData.getSchemas(catalogFilter, "%");){
            String string = this.findMatchInResultSet(schemaFilter, schemas, "TABLE_SCHEM", "schema");
            return string;
        }
    }

    private String getTableNameFromMetaData(DatabaseMetaData metaData, String catalogFilter, String schemaFilter, String tableName) throws SQLException {
        try (ResultSet tables = metaData.getTables(catalogFilter, schemaFilter, "%", null);){
            String string = this.findMatchInResultSet(tableName, tables, "TABLE_NAME", "table");
            return string;
        }
    }

    String findMatchInResultSet(String stringToFind, ResultSet resultSet, String column, String description) throws SQLException {
        int exactMatches = 0;
        String exactMatch = null;
        int inexactMatches = 0;
        String inexactMatch = null;
        if (resultSet != null) {
            while (resultSet.next()) {
                String name = resultSet.getString(column);
                if (name.equals(stringToFind)) {
                    ++exactMatches;
                    exactMatch = name;
                    continue;
                }
                if (!name.equalsIgnoreCase(stringToFind)) continue;
                ++inexactMatches;
                inexactMatch = name;
            }
        }
        if (exactMatches == 1) {
            return exactMatch;
        }
        if (inexactMatches > 1 || exactMatches > 1) {
            throw new JdbcConnectorException("Multiple " + description + "s were found that match \"" + stringToFind + "\"");
        }
        if (inexactMatches == 1) {
            return inexactMatch;
        }
        throw new JdbcConnectorException("No " + description + " was found that matches \"" + stringToFind + "\"");
    }

    private List<String> getPrimaryKeyColumnNamesFromMetaData(DatabaseMetaData metaData, String catalogFilter, String schemaFilter, String tableName, String ids) throws SQLException {
        ArrayList<String> keys = new ArrayList<String>();
        if (ids != null && !ids.isEmpty()) {
            keys.addAll(Arrays.asList(ids.split(",")));
            for (String key : keys) {
                this.checkColumnExistsInTable(tableName, metaData, catalogFilter, schemaFilter, key);
            }
        } else {
            try (ResultSet primaryKeys = metaData.getPrimaryKeys(catalogFilter, schemaFilter, tableName);){
                while (primaryKeys.next()) {
                    String key = primaryKeys.getString("COLUMN_NAME");
                    keys.add(key);
                }
                if (keys.isEmpty()) {
                    throw new JdbcConnectorException("The table " + tableName + " does not have a primary key column.");
                }
            }
        }
        return keys;
    }

    private Map<String, TableMetaData.ColumnMetaData> createColumnMetaDataMap(DatabaseMetaData metaData, String catalogFilter, String schemaFilter, String tableName) throws SQLException {
        HashMap<String, TableMetaData.ColumnMetaData> result = new HashMap<String, TableMetaData.ColumnMetaData>();
        try (ResultSet columnData = metaData.getColumns(catalogFilter, schemaFilter, tableName, "%");){
            while (columnData.next()) {
                String columnName = columnData.getString("COLUMN_NAME");
                int dataType = columnData.getInt("DATA_TYPE");
                int nullableCode = columnData.getInt("NULLABLE");
                boolean nullable = nullableCode != 0;
                result.put(columnName, new TableMetaData.ColumnMetaData(JDBCType.valueOf(dataType), nullable));
            }
        }
        return result;
    }

    private void checkColumnExistsInTable(String tableName, DatabaseMetaData metaData, String catalogFilter, String schemaFilter, String columnName) throws SQLException {
        int caseInsensitiveMatches = 0;
        try (ResultSet columnData = metaData.getColumns(catalogFilter, schemaFilter, tableName, "%");){
            while (columnData.next()) {
                String realColumnName = columnData.getString("COLUMN_NAME");
                if (columnName.equals(realColumnName)) {
                    return;
                }
                if (!columnName.equalsIgnoreCase(realColumnName)) continue;
                ++caseInsensitiveMatches;
            }
        }
        if (caseInsensitiveMatches > 1) {
            throw new JdbcConnectorException("The table " + tableName + " has more than one column that matches " + columnName);
        }
        if (caseInsensitiveMatches == 0) {
            throw new JdbcConnectorException("The table " + tableName + " does not have a column named " + columnName);
        }
    }
}

