/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.api.config;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.fluo.api.exceptions.FluoException;

public class SimpleConfiguration {
    private Configuration internalConfig;

    public SimpleConfiguration() {
        CompositeConfiguration compositeConfig = new CompositeConfiguration();
        compositeConfig.setThrowExceptionOnMissing(true);
        compositeConfig.setDelimiterParsingDisabled(true);
        this.internalConfig = compositeConfig;
    }

    private SimpleConfiguration(Configuration subset) {
        this.internalConfig = subset;
    }

    public SimpleConfiguration(File propertiesFile) {
        this();
        try {
            PropertiesConfiguration config = new PropertiesConfiguration();
            config.setDelimiterParsingDisabled(true);
            config.load(propertiesFile);
            ((CompositeConfiguration)this.internalConfig).addConfiguration((Configuration)config);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public SimpleConfiguration(InputStream in) {
        this();
        try {
            PropertiesConfiguration config = new PropertiesConfiguration();
            config.setDelimiterParsingDisabled(true);
            config.load(in);
            ((CompositeConfiguration)this.internalConfig).addConfiguration((Configuration)config);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public SimpleConfiguration(SimpleConfiguration other) {
        this();
        Iterator iter = other.internalConfig.getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.internalConfig.setProperty(key, other.internalConfig.getProperty(key));
        }
    }

    public SimpleConfiguration(Map<String, String> map) {
        this();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.internalConfig.setProperty(entry.getKey(), (Object)entry.getValue());
        }
    }

    public void clear() {
        this.internalConfig.clear();
    }

    public void clearProperty(String key) {
        this.internalConfig.clearProperty(key);
    }

    public boolean containsKey(String key) {
        return this.internalConfig.containsKey(key);
    }

    public boolean getBoolean(String key) {
        return this.internalConfig.getBoolean(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.internalConfig.getBoolean(key, defaultValue);
    }

    public int getInt(String key) {
        return this.internalConfig.getInt(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.internalConfig.getInt(key, defaultValue);
    }

    public Iterator<String> getKeys() {
        return this.internalConfig.getKeys();
    }

    public Iterator<String> getKeys(String key) {
        return this.internalConfig.getKeys(key);
    }

    public long getLong(String key) {
        return this.internalConfig.getLong(key);
    }

    public long getLong(String key, long defaultValue) {
        return this.internalConfig.getLong(key, defaultValue);
    }

    public String getRawString(String key) {
        Object val = this.internalConfig.getProperty(key);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    public String getString(String key) {
        return this.internalConfig.getString(key);
    }

    public String getString(String key, String defaultValue) {
        return this.internalConfig.getString(key, defaultValue);
    }

    public void save(File file) {
        PropertiesConfiguration pconf = new PropertiesConfiguration();
        pconf.setDelimiterParsingDisabled(true);
        pconf.append(this.internalConfig);
        try {
            pconf.save(file);
        }
        catch (ConfigurationException e) {
            throw new FluoException(e);
        }
    }

    public void save(OutputStream out) {
        PropertiesConfiguration pconf = new PropertiesConfiguration();
        pconf.setDelimiterParsingDisabled(true);
        pconf.append(this.internalConfig);
        try {
            pconf.save(out);
        }
        catch (ConfigurationException e) {
            throw new FluoException(e);
        }
    }

    public void setProperty(String key, Boolean value) {
        this.internalConfig.setProperty(key, (Object)value);
    }

    public void setProperty(String key, Integer value) {
        this.internalConfig.setProperty(key, (Object)value);
    }

    public void setProperty(String key, Long value) {
        this.internalConfig.setProperty(key, (Object)value);
    }

    public void setProperty(String key, String value) {
        this.internalConfig.setProperty(key, (Object)value);
    }

    public SimpleConfiguration subset(String prefix) {
        return new SimpleConfiguration(this.internalConfig.subset(prefix));
    }

    public String toString() {
        return ConfigurationUtils.toString((Configuration)this.internalConfig);
    }

    public Map<String, String> toMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Iterator<String> ki = this.getKeys();
        while (ki.hasNext()) {
            String k = ki.next();
            builder.put((Object)k, (Object)this.getRawString(k));
        }
        return builder.build();
    }
}

