/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.upserttest.table;

import java.io.File;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.connector.upserttest.sink.UpsertTestSink;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkV2Provider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

@Internal
class UpsertTestDynamicTableSink
implements DynamicTableSink {
    private final DataType physicalRowDataType;
    private final EncodingFormat<SerializationSchema<RowData>> keyEncodingFormat;
    private final EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat;
    private final String outputFilePath;

    UpsertTestDynamicTableSink(DataType physicalRowDataType, EncodingFormat<SerializationSchema<RowData>> keyEncodingFormat, EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat, String outputFilePath) {
        this.physicalRowDataType = (DataType)Preconditions.checkNotNull((Object)physicalRowDataType);
        this.keyEncodingFormat = (EncodingFormat)Preconditions.checkNotNull(keyEncodingFormat);
        this.valueEncodingFormat = (EncodingFormat)Preconditions.checkNotNull(valueEncodingFormat);
        this.outputFilePath = (String)Preconditions.checkNotNull((Object)outputFilePath);
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        ChangelogMode.Builder builder = ChangelogMode.newBuilder();
        for (RowKind kind : requestedMode.getContainedKinds()) {
            if (kind == RowKind.UPDATE_BEFORE) continue;
            builder.addContainedKind(kind);
        }
        return builder.build();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        File outputFile = new File(this.outputFilePath);
        SerializationSchema keySerialization = (SerializationSchema)this.keyEncodingFormat.createRuntimeEncoder(context, this.physicalRowDataType);
        SerializationSchema valueSerialization = (SerializationSchema)this.valueEncodingFormat.createRuntimeEncoder(context, this.physicalRowDataType);
        UpsertTestSink sink = UpsertTestSink.builder().setOutputFile(outputFile).setKeySerializationSchema(keySerialization).setValueSerializationSchema(valueSerialization).build();
        return SinkV2Provider.of(sink, (Integer)1);
    }

    public DynamicTableSink copy() {
        return new UpsertTestDynamicTableSink(this.physicalRowDataType, this.keyEncodingFormat, this.valueEncodingFormat, this.outputFilePath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertTestDynamicTableSink that = (UpsertTestDynamicTableSink)o;
        return Objects.equals(this.physicalRowDataType, that.physicalRowDataType) && Objects.equals(this.keyEncodingFormat, that.keyEncodingFormat) && Objects.equals(this.valueEncodingFormat, that.valueEncodingFormat) && Objects.equals(this.outputFilePath, that.outputFilePath);
    }

    public int hashCode() {
        return Objects.hash(this.physicalRowDataType, this.keyEncodingFormat, this.valueEncodingFormat, this.outputFilePath);
    }

    public String asSummaryString() {
        return "UpsertTestSink";
    }
}

