/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

@PublicEvolving
public class PojoTestUtils {
    public static <T> void assertSerializedAsPojo(Class<T> clazz) throws AssertionError {
        TypeInformation typeInformation = TypeInformation.of(clazz);
        TypeSerializer actualSerializer = typeInformation.createSerializer(new ExecutionConfig());
        ((ObjectAssert)Assertions.assertThat((Object)actualSerializer).withFailMessage("Instances of the class '%s' cannot be serialized as a POJO, but would use a '%s' instead. %nRe-run this test with INFO logging enabled and check messages from the '%s' for possible reasons.", new Object[]{clazz.getSimpleName(), actualSerializer.getClass().getSimpleName(), TypeExtractor.class.getCanonicalName()})).isInstanceOf(PojoSerializer.class);
    }

    public static <T> void assertSerializedAsPojoWithoutKryo(Class<T> clazz) throws AssertionError {
        TypeSerializer actualSerializer;
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.disableGenericTypes();
        TypeInformation typeInformation = TypeInformation.of(clazz);
        try {
            actualSerializer = typeInformation.createSerializer(executionConfig);
        }
        catch (UnsupportedOperationException e) {
            throw new AssertionError((Object)e);
        }
        ((ObjectAssert)Assertions.assertThat((Object)actualSerializer).withFailMessage("Instances of the class '%s' cannot be serialized as a POJO, but would use a '%s' instead. %nRe-run this test with INFO logging enabled and check messages from the '%s' for possible reasons.", new Object[]{clazz.getSimpleName(), actualSerializer.getClass().getSimpleName(), TypeExtractor.class.getCanonicalName()})).isInstanceOf(PojoSerializer.class);
    }
}

