/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

public interface SQLJobClientMode {
    public static EmbeddedSqlClient getEmbeddedSqlClient() {
        return EmbeddedSqlClient.INSTANCE;
    }

    public static GatewaySqlClient getGatewaySqlClient(String host, int port) {
        return new GatewaySqlClient(host, port);
    }

    public static HiveJDBC getHiveJDBC(String host, int port) {
        return new HiveJDBC(host, port);
    }

    public static RestClient getRestClient(String host, int port, String getRestEndpointVersion) {
        return new RestClient(host, port, getRestEndpointVersion);
    }

    public static class RestClient
    extends GatewayClientMode {
        private final String restEndpointVersion;

        public RestClient(String host, int port, String restEndpointVersion) {
            super(host, port);
            this.restEndpointVersion = restEndpointVersion;
        }

        public String getRestEndpointVersion() {
            return this.restEndpointVersion;
        }
    }

    public static class HiveJDBC
    extends GatewayClientMode {
        public HiveJDBC(String host, int port) {
            super(host, port);
        }
    }

    public static class GatewaySqlClient
    extends GatewayClientMode {
        public GatewaySqlClient(String host, int port) {
            super(host, port);
        }
    }

    public static class GatewayClientMode
    implements SQLJobClientMode {
        private final String host;
        private final int port;

        public GatewayClientMode(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }

    public static class EmbeddedSqlClient
    implements SQLJobClientMode {
        public static final EmbeddedSqlClient INSTANCE = new EmbeddedSqlClient();

        private EmbeddedSqlClient() {
        }
    }
}

