/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class TestSignalHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TestSignalHandler.class);
    private static boolean registered = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register() {
        Class<TestSignalHandler> clazz = TestSignalHandler.class;
        synchronized (TestSignalHandler.class) {
            String[] signals;
            String[] stringArray;
            if (registered) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            registered = true;
            if (System.getProperty("os.name").startsWith("Windows")) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "TERM";
                stringArray = stringArray2;
                stringArray2[1] = "INT";
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "TERM";
                stringArray3[1] = "HUP";
                stringArray = stringArray3;
                stringArray3[2] = "INT";
            }
            for (String signalName : signals = stringArray) {
                try {
                    new Handler(signalName);
                }
                catch (Exception e) {
                    LOG.info("Error while registering signal handler", (Throwable)e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static class Handler
    implements SignalHandler {
        private final SignalHandler prevHandler;

        Handler(String name) {
            this.prevHandler = Signal.handle(new Signal(name), this);
        }

        @Override
        public void handle(Signal signal) {
            LOG.warn("RECEIVED SIGNAL {}: SIG{}. Shutting down as requested.", (Object)signal.getNumber(), (Object)signal.getName());
            this.prevHandler.handle(signal);
        }
    }
}

