/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.testutils;

import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class CompletedScheduledFuture<T>
implements ScheduledFuture<T> {
    private final T value;

    private CompletedScheduledFuture(T value) {
        this.value = value;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return 0L;
    }

    @Override
    public int compareTo(Delayed o) {
        return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), o.getDelay(TimeUnit.MILLISECONDS));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.value;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.value;
    }

    public static <T> CompletedScheduledFuture<T> create(T value) {
        return new CompletedScheduledFuture<T>(value);
    }
}

