/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.sequencedmultisetstate.linked;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedHashFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.HashFunction;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.sequencedmultisetstate.linked.RowDataKey;
import org.apache.flink.table.runtime.sequencedmultisetstate.linked.RowDataKeySerializer;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public class RowDataKeySerializerSnapshot
implements TypeSerializerSnapshot<RowDataKey> {
    private RowDataKeySerializer serializer;
    private TypeSerializerSnapshot<RowData> restoredRowDataSerializerSnapshot;

    public RowDataKeySerializerSnapshot() {
    }

    public RowDataKeySerializerSnapshot(RowDataKeySerializer serializer) {
        this.serializer = (RowDataKeySerializer)((Object)Preconditions.checkNotNull((Object)((Object)serializer)));
    }

    public int getCurrentVersion() {
        return 0;
    }

    public void writeSnapshot(DataOutputView out) throws IOException {
        RowDataKeySerializerSnapshot.store(this.serializer.equaliser, out);
        RowDataKeySerializerSnapshot.store(this.serializer.hashFunction, out);
        TypeSerializerSnapshot.writeVersionedSnapshot((DataOutputView)out, (TypeSerializerSnapshot)this.serializer.serializer.snapshotConfiguration());
    }

    public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        Preconditions.checkArgument((readVersion == 0 ? 1 : 0) != 0, (Object)("Unexpected version: " + readVersion));
        GeneratedRecordEqualiser equaliser = (GeneratedRecordEqualiser)this.restore(in, userCodeClassLoader);
        GeneratedHashFunction hashFunction = (GeneratedHashFunction)this.restore(in, userCodeClassLoader);
        this.restoredRowDataSerializerSnapshot = TypeSerializerSnapshot.readVersionedSnapshot((DataInputView)in, (ClassLoader)userCodeClassLoader);
        this.serializer = new RowDataKeySerializer((TypeSerializer<RowData>)this.restoredRowDataSerializerSnapshot.restoreSerializer(), (RecordEqualiser)equaliser.newInstance(userCodeClassLoader), (HashFunction)hashFunction.newInstance(userCodeClassLoader), equaliser, hashFunction);
    }

    private static void store(Object object, DataOutputView out) throws IOException {
        byte[] bytes = InstantiationUtil.serializeObject((Object)object);
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    private <T> T restore(DataInputView in, ClassLoader classLoader) throws IOException {
        int len = in.readInt();
        byte[] bytes = new byte[len];
        in.read(bytes);
        try {
            return (T)InstantiationUtil.deserializeObject((byte[])bytes, (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public TypeSerializer<RowDataKey> restoreSerializer() {
        return this.serializer;
    }

    public TypeSerializerSchemaCompatibility<RowDataKey> resolveSchemaCompatibility(TypeSerializerSnapshot<RowDataKey> oldSerializerSnapshot) {
        if (!(oldSerializerSnapshot instanceof RowDataKeySerializerSnapshot)) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        RowDataKeySerializerSnapshot old = (RowDataKeySerializerSnapshot)oldSerializerSnapshot;
        TypeSerializerSchemaCompatibility compatibility = old.restoredRowDataSerializerSnapshot.resolveSchemaCompatibility(old.serializer.serializer.snapshotConfiguration());
        return RowDataKeySerializerSnapshot.mapToOuterCompatibility((TypeSerializerSchemaCompatibility<RowData>)compatibility, this.serializer.equalizerInstance, this.serializer.hashFunctionInstance, this.serializer.equaliser, this.serializer.hashFunction);
    }

    private static TypeSerializerSchemaCompatibility<RowDataKey> mapToOuterCompatibility(TypeSerializerSchemaCompatibility<RowData> rowDataCmp, RecordEqualiser equaliserInstance, HashFunction hashFunctionInstance, GeneratedRecordEqualiser equaliser, GeneratedHashFunction hashFunction) {
        if (rowDataCmp.isCompatibleAsIs()) {
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
        if (rowDataCmp.isCompatibleAfterMigration()) {
            return TypeSerializerSchemaCompatibility.compatibleAfterMigration();
        }
        if (rowDataCmp.isCompatibleWithReconfiguredSerializer()) {
            return TypeSerializerSchemaCompatibility.compatibleWithReconfiguredSerializer((TypeSerializer)new RowDataKeySerializer((TypeSerializer<RowData>)rowDataCmp.getReconfiguredSerializer(), equaliserInstance, hashFunctionInstance, equaliser, hashFunction));
        }
        if (rowDataCmp.isIncompatible()) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        throw new UnsupportedOperationException("Unknown compatibility mode: " + String.valueOf(rowDataCmp));
    }
}

