/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.runtime.operators.sort.PartialOrderPriorityQueue;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.Preconditions;

public class BinaryMergeIterator<Entry>
implements MutableObjectIterator<Entry> {
    private final PartialOrderPriorityQueue<HeadStream<Entry>> heap;
    private HeadStream<Entry> currHead;

    public BinaryMergeIterator(List<MutableObjectIterator<Entry>> iterators, List<Entry> reusableEntries, Comparator<Entry> comparator) throws IOException {
        Preconditions.checkArgument((iterators.size() == reusableEntries.size() ? 1 : 0) != 0);
        this.heap = new PartialOrderPriorityQueue((o1, o2) -> comparator.compare(((HeadStream)o1).getHead(), ((HeadStream)o2).getHead()), iterators.size());
        for (int i = 0; i < iterators.size(); ++i) {
            this.heap.add(new HeadStream(iterators.get(i), reusableEntries.get(i)));
        }
    }

    public Entry next(Entry reuse) throws IOException {
        return this.next();
    }

    public Entry next() throws IOException {
        if (this.currHead != null) {
            if (!((HeadStream)this.currHead).nextHead()) {
                this.heap.poll();
            } else {
                this.heap.adjustTop();
            }
        }
        if (this.heap.size() > 0) {
            this.currHead = (HeadStream)this.heap.peek();
            return (Entry)((HeadStream)this.currHead).getHead();
        }
        return null;
    }

    private static final class HeadStream<Entry> {
        private final MutableObjectIterator<Entry> iterator;
        private Entry head;

        private HeadStream(MutableObjectIterator<Entry> iterator, Entry head) throws IOException {
            this.iterator = iterator;
            this.head = head;
            if (!this.nextHead()) {
                throw new IllegalStateException();
            }
        }

        private Entry getHead() {
            return this.head;
        }

        private boolean nextHead() throws IOException {
            this.head = this.iterator.next(this.head);
            return this.head != null;
        }
    }
}

