/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.file.testutils.catalog;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.file.testutils.catalog.TestFileSystemCatalog;

public class TestFileSystemCatalogFactory
implements CatalogFactory {
    public static final ConfigOption<String> PATH = ConfigOptions.key((String)"path").stringType().noDefaultValue().withDescription("Catalog base DFS path, used for inferring the sink table path. The default strategy for a table path is: ${catalog.path}/${db_name}/${table_name}");
    public static final ConfigOption<String> DEFAULT_DATABASE = ConfigOptions.key((String)"default-database").stringType().defaultValue((Object)"default");

    public String factoryIdentifier() {
        return "test-filesystem";
    }

    public Catalog createCatalog(CatalogFactory.Context context) {
        FactoryUtil.CatalogFactoryHelper helper = FactoryUtil.createCatalogFactoryHelper((CatalogFactory)this, (CatalogFactory.Context)context);
        helper.validate();
        return new TestFileSystemCatalog((String)helper.getOptions().get(PATH), context.getName(), (String)helper.getOptions().get(DEFAULT_DATABASE));
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet set = new HashSet();
        set.add(PATH);
        set.add(DEFAULT_DATABASE);
        return set;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Collections.emptySet();
    }
}

