/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.AsyncTableFunction;

@PublicEvolving
public abstract class AsyncLookupFunction
extends AsyncTableFunction<RowData> {
    public abstract CompletableFuture<Collection<RowData>> asyncLookup(RowData var1);

    public final void eval(CompletableFuture<Collection<RowData>> future, Object ... keys) {
        GenericRowData keyRow = GenericRowData.of(keys);
        this.asyncLookup(keyRow).whenComplete((result, exception) -> {
            if (exception != null) {
                future.completeExceptionally(new TableException(String.format("Failed to asynchronously lookup entries with key '%s'", keyRow), (Throwable)exception));
                return;
            }
            future.complete((Collection<RowData>)result);
        });
    }
}

