/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
class CurrentWatermarkTypeStrategy
implements TypeStrategy {
    CurrentWatermarkTypeStrategy() {
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        LogicalType inputType = callContext.getArgumentDataTypes().get(0).getLogicalType();
        if (inputType.is(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)) {
            return Optional.of(DataTypes.TIMESTAMP(3));
        }
        if (inputType.is(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)) {
            return Optional.of(DataTypes.TIMESTAMP_LTZ(3));
        }
        return Optional.empty();
    }
}

