/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CommonCatalogOptions;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.listener.CatalogModificationListener;
import org.apache.flink.table.catalog.listener.CatalogModificationListenerFactory;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.CatalogStoreFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.TableFactoryService;
import org.apache.flink.table.factories.TableSinkFactoryContextImpl;
import org.apache.flink.table.factories.TableSourceFactoryContextImpl;
import org.apache.flink.table.legacy.factories.TableSinkFactory;
import org.apache.flink.table.legacy.factories.TableSourceFactory;
import org.apache.flink.table.legacy.sinks.TableSink;
import org.apache.flink.table.legacy.sources.TableSource;

@Internal
public class TableFactoryUtil {
    public static <T> TableSource<T> findAndCreateTableSource(TableSourceFactory.Context context) {
        try {
            return ((TableSourceFactory)TableFactoryService.find(TableSourceFactory.class, (Map)((ResolvedCatalogTable)context.getTable()).toProperties())).createTableSource(context);
        }
        catch (Throwable t) {
            throw new TableException("findAndCreateTableSource failed.", t);
        }
    }

    public static <T> TableSource<T> findAndCreateTableSource(ObjectIdentifier objectIdentifier, CatalogTable catalogTable, ReadableConfig configuration, boolean isTemporary) {
        TableSourceFactoryContextImpl context = new TableSourceFactoryContextImpl(objectIdentifier, catalogTable, configuration, isTemporary);
        return TableFactoryUtil.findAndCreateTableSource((TableSourceFactory.Context)context);
    }

    public static <T> TableSink<T> findAndCreateTableSink(TableSinkFactory.Context context) {
        try {
            return ((TableSinkFactory)TableFactoryService.find(TableSinkFactory.class, (Map)((ResolvedCatalogTable)context.getTable()).toProperties())).createTableSink(context);
        }
        catch (Throwable t) {
            throw new TableException("findAndCreateTableSink failed.", t);
        }
    }

    public static <T> TableSink<T> findAndCreateTableSink(ObjectIdentifier objectIdentifier, CatalogTable catalogTable, ReadableConfig configuration, boolean isStreamingMode, boolean isTemporary) {
        TableSinkFactoryContextImpl context = new TableSinkFactoryContextImpl(objectIdentifier, catalogTable, configuration, !isStreamingMode, isTemporary);
        return TableFactoryUtil.findAndCreateTableSink((TableSinkFactory.Context)context);
    }

    public static boolean isLegacyConnectorOptions(ReadableConfig configuration, boolean isStreamingMode, ObjectIdentifier objectIdentifier, CatalogTable catalogTable, boolean isTemporary) {
        DescriptorProperties properties = new DescriptorProperties(true);
        properties.putProperties(catalogTable.getOptions());
        if (properties.containsKey("connector.type")) {
            return true;
        }
        try {
            TableFactoryUtil.findAndCreateTableSink(objectIdentifier, catalogTable, configuration, isStreamingMode, isTemporary);
            return true;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    public static List<CatalogModificationListener> findCatalogModificationListenerList(final ReadableConfig configuration, final ClassLoader classLoader) {
        return configuration.getOptional(TableConfigOptions.TABLE_CATALOG_MODIFICATION_LISTENERS).orElse(Collections.emptyList()).stream().map(identifier -> ((CatalogModificationListenerFactory)FactoryUtil.discoverFactory((ClassLoader)classLoader, CatalogModificationListenerFactory.class, (String)identifier)).createListener(new CatalogModificationListenerFactory.Context(){

            @Override
            public ReadableConfig getConfiguration() {
                return configuration;
            }

            @Override
            public ClassLoader getUserClassLoader() {
                return classLoader;
            }
        })).collect(Collectors.toList());
    }

    public static CatalogStoreFactory findAndCreateCatalogStoreFactory(Configuration configuration, ClassLoader classLoader) {
        String identifier = (String)configuration.get(CommonCatalogOptions.TABLE_CATALOG_STORE_KIND);
        CatalogStoreFactory catalogStoreFactory = (CatalogStoreFactory)FactoryUtil.discoverFactory((ClassLoader)classLoader, CatalogStoreFactory.class, (String)identifier);
        return catalogStoreFactory;
    }

    public static CatalogStoreFactory.Context buildCatalogStoreFactoryContext(Configuration configuration, ClassLoader classLoader) {
        String identifier = (String)configuration.get(CommonCatalogOptions.TABLE_CATALOG_STORE_KIND);
        String catalogStoreOptionPrefix = "table.catalog-store." + identifier + ".";
        Map options = new DelegatingConfiguration(configuration, catalogStoreOptionPrefix).toMap();
        FactoryUtil.DefaultCatalogStoreContext context = new FactoryUtil.DefaultCatalogStoreContext(options, (ReadableConfig)configuration, classLoader);
        return context;
    }
}

