/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ddl.DropOperation;

public class DropDatabaseOperation
implements DropOperation {
    private final String catalogName;
    private final String databaseName;
    private final boolean ifExists;
    private final boolean cascade;

    public DropDatabaseOperation(String catalogName, String databaseName, boolean ifExists, boolean cascade) {
        this.catalogName = catalogName;
        this.databaseName = databaseName;
        this.ifExists = ifExists;
        this.cascade = cascade;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean isCascade() {
        return this.cascade;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    @Override
    public String asSummaryString() {
        StringBuilder summaryString = new StringBuilder("DROP DATABASE");
        summaryString.append(this.ifExists ? " IF EXISTS " : "");
        summaryString.append(" " + this.catalogName + "." + this.databaseName);
        summaryString.append(this.cascade ? " CASCADE" : " RESTRICT");
        return summaryString.toString();
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        try {
            ctx.getCatalogManager().dropDatabase(this.getCatalogName(), this.getDatabaseName(), this.isIfExists(), this.isCascade());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (DatabaseNotEmptyException | DatabaseNotExistException e) {
            throw new ValidationException(String.format("Could not execute %s", this.asSummaryString()), e);
        }
        catch (Exception e) {
            throw new TableException(String.format("Could not execute %s", this.asSummaryString()), (Throwable)e);
        }
    }
}

