/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.CreateOperation;

public class CreateCatalogFunctionOperation
implements CreateOperation {
    private final ObjectIdentifier functionIdentifier;
    private final CatalogFunction catalogFunction;
    private final boolean ignoreIfExists;
    private final boolean isTemporary;

    public CreateCatalogFunctionOperation(ObjectIdentifier functionIdentifier, CatalogFunction catalogFunction, boolean ignoreIfExists, boolean isTemporary) {
        this.functionIdentifier = functionIdentifier;
        this.catalogFunction = catalogFunction;
        this.ignoreIfExists = ignoreIfExists;
        this.isTemporary = isTemporary;
    }

    public CatalogFunction getCatalogFunction() {
        return this.catalogFunction;
    }

    public ObjectIdentifier getFunctionIdentifier() {
        return this.functionIdentifier;
    }

    public boolean isIgnoreIfExists() {
        return this.ignoreIfExists;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("catalogFunction", this.catalogFunction.getDetailedDescription());
        params.put("identifier", this.functionIdentifier);
        params.put("ignoreIfExists", this.ignoreIfExists);
        params.put("isTemporary", this.isTemporary);
        return OperationUtils.formatWithChildren("CREATE CATALOG FUNCTION", params, Collections.emptyList(), Operation::asSummaryString);
    }

    public String getFunctionName() {
        return this.functionIdentifier.getObjectName();
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        try {
            if (this.isTemporary) {
                ctx.getFunctionCatalog().registerTemporaryCatalogFunction(UnresolvedIdentifier.of((List)this.functionIdentifier.toList()), this.catalogFunction, this.ignoreIfExists);
            } else {
                Catalog catalog = ctx.getCatalogManager().getCatalogOrThrowException(this.functionIdentifier.getCatalogName());
                catalog.createFunction(this.functionIdentifier.toObjectPath(), this.catalogFunction, this.ignoreIfExists);
            }
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (FunctionAlreadyExistException e) {
            throw new ValidationException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new TableException(String.format("Could not execute %s", this.asSummaryString()), (Throwable)e);
        }
    }
}

