/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.time.ZoneId;
import java.util.TimeZone;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;

@Internal
public class TableConfigValidation {
    public static void validateTimeZone(String zone) {
        boolean isValid;
        try {
            isValid = TimeZone.getTimeZone(zone).toZoneId().equals(ZoneId.of(zone));
        }
        catch (Exception e) {
            isValid = false;
        }
        if (!isValid) {
            throw new ValidationException("Invalid time zone. The value should be a Time Zone Database (TZDB) ID such as 'America/Los_Angeles' to include daylight saving time. Fixed offsets are supported using 'GMT-03:00' or 'GMT+03:00'. Or use 'UTC' without time zone and daylight saving time.");
        }
    }

    private TableConfigValidation() {
    }
}

