/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.util.List;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.internal.ResultProvider;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

@Internal
class StaticResultProvider
implements ResultProvider {
    static final RowDataToStringConverter SIMPLE_ROW_DATA_TO_STRING_CONVERTER = rowData -> {
        GenericRowData genericRowData = (GenericRowData)rowData;
        String[] results = new String[rowData.getArity()];
        for (int i = 0; i < results.length; ++i) {
            Object value = genericRowData.getField(i);
            results[i] = Boolean.TRUE.equals(value) ? "TRUE" : (Boolean.FALSE.equals(value) ? "FALSE" : (value == null ? "<NULL>" : "" + value));
        }
        return results;
    };
    private final List<Row> rows;
    private final Function<Row, RowData> externalToInternalConverter;

    public StaticResultProvider(List<Row> rows) {
        this(rows, StaticResultProvider::rowToInternalRow);
    }

    public StaticResultProvider(List<Row> rows, Function<Row, RowData> externalToInternalConverter) {
        this.rows = rows;
        this.externalToInternalConverter = externalToInternalConverter;
    }

    @Override
    public StaticResultProvider setJobClient(JobClient jobClient) {
        return this;
    }

    @Override
    public CloseableIterator<RowData> toInternalIterator() {
        return CloseableIterator.adapterForIterator(this.rows.stream().map(this.externalToInternalConverter).iterator());
    }

    @Override
    public CloseableIterator<Row> toExternalIterator() {
        return CloseableIterator.adapterForIterator(this.rows.iterator());
    }

    @Override
    public RowDataToStringConverter getRowDataStringConverter() {
        return SIMPLE_ROW_DATA_TO_STRING_CONVERTER;
    }

    @Override
    public boolean isFirstRowReady() {
        return true;
    }

    @VisibleForTesting
    static RowData rowToInternalRow(Row row) {
        Object[] values = new Object[row.getArity()];
        for (int i = 0; i < row.getArity(); ++i) {
            Object value = row.getField(i);
            if (value == null) {
                values[i] = null;
                continue;
            }
            if (value instanceof String) {
                values[i] = StringData.fromString((String)((String)value));
                continue;
            }
            if (value instanceof Boolean || value instanceof Long || value instanceof Integer) {
                values[i] = value;
                continue;
            }
            throw new TableException("Cannot convert row type");
        }
        return GenericRowData.of((Object[])values);
    }
}

