/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.expressions.resolver.LocalOverWindow;
import org.apache.flink.table.expressions.resolver.rules.ResolverRule;
import org.apache.flink.table.expressions.resolver.rules.RuleExpressionVisitor;
import org.apache.flink.table.expressions.utils.ApiExpressionDefaultVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@Internal
final class OverWindowResolverRule
implements ResolverRule {
    private static final WindowKindExtractor OVER_WINDOW_KIND_EXTRACTOR = new WindowKindExtractor();

    OverWindowResolverRule() {
    }

    @Override
    public List<Expression> apply(List<Expression> expression, ResolverRule.ResolutionContext context) {
        return expression.stream().map(expr -> (Expression)expr.accept((ExpressionVisitor)new ExpressionResolverVisitor(context))).collect(Collectors.toList());
    }

    private static class WindowKindExtractor
    extends ApiExpressionDefaultVisitor<WindowKind> {
        private WindowKindExtractor() {
        }

        @Override
        public WindowKind visit(ValueLiteralExpression valueLiteral) {
            LogicalType literalType = valueLiteral.getOutputDataType().getLogicalType();
            if (LogicalTypeChecks.hasRoot((LogicalType)literalType, (LogicalTypeRoot)LogicalTypeRoot.BIGINT)) {
                return WindowKind.ROW;
            }
            if (LogicalTypeChecks.hasRoot((LogicalType)literalType, (LogicalTypeRoot)LogicalTypeRoot.INTERVAL_DAY_TIME)) {
                return WindowKind.RANGE;
            }
            return this.defaultMethod((Expression)valueLiteral);
        }

        @Override
        public WindowKind visit(UnresolvedCallExpression unresolvedCall) {
            FunctionDefinition definition = unresolvedCall.getFunctionDefinition();
            if (definition == BuiltInFunctionDefinitions.UNBOUNDED_ROW) {
                return WindowKind.ROW;
            }
            if (definition == BuiltInFunctionDefinitions.UNBOUNDED_RANGE) {
                return WindowKind.RANGE;
            }
            return this.defaultMethod(unresolvedCall);
        }

        @Override
        protected WindowKind defaultMethod(Expression expression) {
            throw new ValidationException("An over window expects literal or unbounded bounds for preceding.");
        }
    }

    private static enum WindowKind {
        ROW,
        RANGE;

    }

    private static class ExpressionResolverVisitor
    extends RuleExpressionVisitor<Expression> {
        ExpressionResolverVisitor(ResolverRule.ResolutionContext context) {
            super(context);
        }

        @Override
        public Expression visit(UnresolvedCallExpression unresolvedCall) {
            if (unresolvedCall.getFunctionDefinition() == BuiltInFunctionDefinitions.OVER) {
                List<Expression> children = unresolvedCall.getChildren();
                Expression alias = children.get(1);
                LocalOverWindow referenceWindow = this.resolutionContext.getOverWindow(alias).orElseThrow(() -> new ValidationException("Could not resolve over call."));
                Expression following = this.calculateOverWindowFollowing(referenceWindow);
                ArrayList<Expression> newArgs = new ArrayList<Expression>(Arrays.asList(children.get(0), referenceWindow.getOrderBy(), referenceWindow.getPreceding(), following));
                newArgs.addAll(referenceWindow.getPartitionBy());
                return unresolvedCall.replaceArgs(newArgs);
            }
            return unresolvedCall.replaceArgs(unresolvedCall.getChildren().stream().map(expr -> (Expression)expr.accept((ExpressionVisitor)this)).collect(Collectors.toList()));
        }

        private Expression calculateOverWindowFollowing(LocalOverWindow referenceWindow) {
            return referenceWindow.getFollowing().orElseGet(() -> {
                WindowKind kind = (WindowKind)((Object)((Object)referenceWindow.getPreceding().accept((ExpressionVisitor)OVER_WINDOW_KIND_EXTRACTOR)));
                if (kind == WindowKind.ROW) {
                    return ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.CURRENT_ROW, new Expression[0]);
                }
                return ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.CURRENT_RANGE, new Expression[0]);
            });
        }

        @Override
        protected Expression defaultMethod(Expression expression) {
            return expression;
        }
    }
}

