/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.internal.TableDescriptorUtil;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.SchemaTranslator;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;

@Internal
public class StatementSetImpl<E extends TableEnvironmentInternal>
implements StatementSet {
    protected final E tableEnvironment;
    protected final List<ModifyOperation> operations = new ArrayList<ModifyOperation>();

    protected StatementSetImpl(E tableEnvironment) {
        this.tableEnvironment = tableEnvironment;
    }

    @Override
    public StatementSet addInsertSql(String statement) {
        List<Operation> operations = this.tableEnvironment.getParser().parse(statement);
        if (operations.size() != 1) {
            throw new TableException("Only single statement is supported.");
        }
        Operation operation = operations.get(0);
        if (!(operation instanceof ModifyOperation)) {
            throw new TableException("Only insert statement is supported now.");
        }
        this.operations.add((ModifyOperation)operation);
        return this;
    }

    @Override
    public StatementSet addInsert(String targetPath, Table table) {
        return this.addInsert(targetPath, table, false);
    }

    @Override
    public StatementSet addInsert(String targetPath, Table table, boolean overwrite) {
        UnresolvedIdentifier unresolvedIdentifier = this.tableEnvironment.getParser().parseIdentifier(targetPath);
        ObjectIdentifier objectIdentifier = this.tableEnvironment.getCatalogManager().qualifyIdentifier(unresolvedIdentifier);
        this.operations.add(new CatalogSinkModifyOperation(objectIdentifier, table.getQueryOperation(), Collections.emptyMap(), overwrite, Collections.emptyMap()));
        return this;
    }

    @Override
    public StatementSet addInsert(TableDescriptor targetDescriptor, Table table) {
        return this.addInsert(targetDescriptor, table, false);
    }

    @Override
    public StatementSet addInsert(TableDescriptor targetDescriptor, Table table, boolean overwrite) {
        String path = TableDescriptorUtil.getUniqueAnonymousPath();
        SchemaTranslator.ConsumingResult schemaTranslationResult = SchemaTranslator.createConsumingResult(this.tableEnvironment.getCatalogManager().getDataTypeFactory(), table.getResolvedSchema().toSourceRowDataType(), targetDescriptor.getSchema().orElse(null), false);
        TableDescriptor updatedDescriptor = targetDescriptor.toBuilder().schema(schemaTranslationResult.getSchema()).build();
        this.tableEnvironment.createTemporaryTable(path, updatedDescriptor);
        return this.addInsert(path, table, overwrite);
    }

    @Override
    public String explain(ExplainDetail ... extraDetails) {
        List<Operation> operationList = this.operations.stream().map(o -> o).collect(Collectors.toList());
        return this.tableEnvironment.explainInternal(operationList, extraDetails);
    }

    @Override
    public TableResult execute() {
        try {
            TableResult tableResult = this.tableEnvironment.executeInternal(this.operations);
            return tableResult;
        }
        finally {
            this.operations.clear();
        }
    }

    @Experimental
    public String getJsonPlan() {
        return this.tableEnvironment.getJsonPlan(this.operations);
    }
}

