/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.JsonExistsOnError;
import org.apache.flink.table.api.JsonValueOnEmptyOrError;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;

@PublicEvolving
public abstract class BaseExpressions<InType, OutType> {
    protected abstract Expression toExpr();

    protected abstract OutType toApiSpecificExpression(Expression var1);

    public OutType as(String name, String ... extraNames) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.AS, (Expression[])Stream.concat(Stream.of(this.toExpr(), ApiExpressionUtils.valueLiteral(name)), Stream.of(extraNames).map(ApiExpressionUtils::valueLiteral)).toArray(Expression[]::new)));
    }

    public OutType and(InType other) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.AND, this.toExpr(), ApiExpressionUtils.objectToExpression(other)));
    }

    public OutType or(InType other) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.OR, this.toExpr(), ApiExpressionUtils.objectToExpression(other)));
    }

    public OutType isGreater(InType other) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, this.toExpr(), ApiExpressionUtils.objectToExpression(other)));
    }

    public OutType isGreaterOrEqual(InType other) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL, this.toExpr(), ApiExpressionUtils.objectToExpression(other)));
    }

    public OutType isLess(InType other) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN, this.toExpr(), ApiExpressionUtils.objectToExpression(other)));
    }

    public OutType isLessOrEqual(InType other) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL, this.toExpr(), ApiExpressionUtils.objectToExpression(other)));
    }

    public OutType isEqual(InType other) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, this.toExpr(), ApiExpressionUtils.objectToExpression(other)));
    }

    public OutType isNotEqual(InType other) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.NOT_EQUALS, this.toExpr(), ApiExpressionUtils.objectToExpression(other)));
    }

    public OutType plus(InType other) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.PLUS, this.toExpr(), ApiExpressionUtils.objectToExpression(other)));
    }

    public OutType minus(InType other) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.MINUS, this.toExpr(), ApiExpressionUtils.objectToExpression(other)));
    }

    public OutType dividedBy(InType other) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.DIVIDE, this.toExpr(), ApiExpressionUtils.objectToExpression(other)));
    }

    public OutType times(InType other) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.TIMES, this.toExpr(), ApiExpressionUtils.objectToExpression(other)));
    }

    public OutType between(InType lowerBound, InType upperBound) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.BETWEEN, this.toExpr(), ApiExpressionUtils.objectToExpression(lowerBound), ApiExpressionUtils.objectToExpression(upperBound)));
    }

    public OutType notBetween(InType lowerBound, InType upperBound) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.NOT_BETWEEN, this.toExpr(), ApiExpressionUtils.objectToExpression(lowerBound), ApiExpressionUtils.objectToExpression(upperBound)));
    }

    public OutType then(InType ifTrue, InType ifFalse) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.IF, this.toExpr(), ApiExpressionUtils.objectToExpression(ifTrue), ApiExpressionUtils.objectToExpression(ifFalse)));
    }

    public OutType ifNull(InType nullReplacement) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.IF_NULL, this.toExpr(), ApiExpressionUtils.objectToExpression(nullReplacement)));
    }

    public OutType isNull() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.IS_NULL, this.toExpr()));
    }

    public OutType isNotNull() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.IS_NOT_NULL, this.toExpr()));
    }

    public OutType isTrue() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.IS_TRUE, this.toExpr()));
    }

    public OutType isFalse() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.IS_FALSE, this.toExpr()));
    }

    public OutType isNotTrue() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.IS_NOT_TRUE, this.toExpr()));
    }

    public OutType isNotFalse() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.IS_NOT_FALSE, this.toExpr()));
    }

    public OutType distinct() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.DISTINCT, this.toExpr()));
    }

    public OutType sum() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.SUM, this.toExpr()));
    }

    public OutType sum0() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.SUM0, this.toExpr()));
    }

    public OutType min() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.MIN, this.toExpr()));
    }

    public OutType max() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.MAX, this.toExpr()));
    }

    public OutType count() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.COUNT, this.toExpr()));
    }

    public OutType avg() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.AVG, this.toExpr()));
    }

    public OutType stddevPop() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.STDDEV_POP, this.toExpr()));
    }

    public OutType stddevSamp() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.STDDEV_SAMP, this.toExpr()));
    }

    public OutType varPop() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.VAR_POP, this.toExpr()));
    }

    public OutType varSamp() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.VAR_SAMP, this.toExpr()));
    }

    public OutType collect() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.COLLECT, this.toExpr()));
    }

    public OutType cast(DataType toType) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.CAST, new Expression[]{this.toExpr(), ApiExpressionUtils.typeLiteral(toType)}));
    }

    @Deprecated
    public OutType cast(TypeInformation<?> toType) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.CAST, new Expression[]{this.toExpr(), ApiExpressionUtils.typeLiteral(TypeConversions.fromLegacyInfoToDataType(toType))}));
    }

    public OutType asc() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.ORDER_ASC, this.toExpr()));
    }

    public OutType desc() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.ORDER_DESC, this.toExpr()));
    }

    @SafeVarargs
    public final OutType in(InType ... elements) {
        Expression[] args = (Expression[])Stream.concat(Stream.of(this.toExpr()), Arrays.stream(elements).map(ApiExpressionUtils::objectToExpression)).toArray(Expression[]::new);
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.IN, args));
    }

    public OutType in(Table table) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.IN, new Expression[]{this.toExpr(), ApiExpressionUtils.tableRef(table.toString(), table)}));
    }

    public OutType start() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.WINDOW_START, this.toExpr()));
    }

    public OutType end() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.WINDOW_END, this.toExpr()));
    }

    public OutType mod(InType other) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.MOD, this.toExpr(), ApiExpressionUtils.objectToExpression(other)));
    }

    public OutType exp() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EXP, this.toExpr()));
    }

    public OutType log10() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LOG10, this.toExpr()));
    }

    public OutType log2() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LOG2, this.toExpr()));
    }

    public OutType ln() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LN, this.toExpr()));
    }

    public OutType log() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LOG, this.toExpr()));
    }

    public OutType log(InType base) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LOG, ApiExpressionUtils.objectToExpression(base), this.toExpr()));
    }

    public OutType power(InType other) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.POWER, this.toExpr(), ApiExpressionUtils.objectToExpression(other)));
    }

    public OutType cosh() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.COSH, this.toExpr()));
    }

    public OutType sqrt() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.SQRT, this.toExpr()));
    }

    public OutType abs() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.ABS, this.toExpr()));
    }

    public OutType floor() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.FLOOR, this.toExpr()));
    }

    public OutType sinh() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.SINH, this.toExpr()));
    }

    public OutType ceil() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.CEIL, this.toExpr()));
    }

    public OutType sin() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.SIN, this.toExpr()));
    }

    public OutType cos() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.COS, this.toExpr()));
    }

    public OutType tan() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.TAN, this.toExpr()));
    }

    public OutType cot() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.COT, this.toExpr()));
    }

    public OutType asin() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.ASIN, this.toExpr()));
    }

    public OutType acos() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.ACOS, this.toExpr()));
    }

    public OutType atan() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.ATAN, this.toExpr()));
    }

    public OutType tanh() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.TANH, this.toExpr()));
    }

    public OutType degrees() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.DEGREES, this.toExpr()));
    }

    public OutType radians() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.RADIANS, this.toExpr()));
    }

    public OutType sign() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.SIGN, this.toExpr()));
    }

    public OutType round(InType places) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.ROUND, this.toExpr(), ApiExpressionUtils.objectToExpression(places)));
    }

    public OutType bin() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.BIN, this.toExpr()));
    }

    public OutType hex() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.HEX, this.toExpr()));
    }

    public OutType truncate(InType n) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.TRUNCATE, this.toExpr(), ApiExpressionUtils.objectToExpression(n)));
    }

    public OutType truncate() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.TRUNCATE, this.toExpr()));
    }

    public OutType substring(InType beginIndex, InType length) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.SUBSTRING, this.toExpr(), ApiExpressionUtils.objectToExpression(beginIndex), ApiExpressionUtils.objectToExpression(length)));
    }

    public OutType substring(InType beginIndex) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.SUBSTRING, this.toExpr(), ApiExpressionUtils.objectToExpression(beginIndex)));
    }

    public OutType trimLeading() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.TRIM, new Expression[]{ApiExpressionUtils.valueLiteral(true), ApiExpressionUtils.valueLiteral(false), ApiExpressionUtils.valueLiteral(" "), this.toExpr()}));
    }

    public OutType trimLeading(InType character) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.TRIM, new Expression[]{ApiExpressionUtils.valueLiteral(true), ApiExpressionUtils.valueLiteral(false), ApiExpressionUtils.objectToExpression(character), this.toExpr()}));
    }

    public OutType trimTrailing() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.TRIM, new Expression[]{ApiExpressionUtils.valueLiteral(false), ApiExpressionUtils.valueLiteral(true), ApiExpressionUtils.valueLiteral(" "), this.toExpr()}));
    }

    public OutType trimTrailing(InType character) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.TRIM, new Expression[]{ApiExpressionUtils.valueLiteral(false), ApiExpressionUtils.valueLiteral(true), ApiExpressionUtils.objectToExpression(character), this.toExpr()}));
    }

    public OutType trim() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.TRIM, new Expression[]{ApiExpressionUtils.valueLiteral(true), ApiExpressionUtils.valueLiteral(true), ApiExpressionUtils.valueLiteral(" "), this.toExpr()}));
    }

    public OutType trim(InType character) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.TRIM, new Expression[]{ApiExpressionUtils.valueLiteral(true), ApiExpressionUtils.valueLiteral(true), ApiExpressionUtils.objectToExpression(character), this.toExpr()}));
    }

    public OutType replace(InType search, InType replacement) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.REPLACE, this.toExpr(), ApiExpressionUtils.objectToExpression(search), ApiExpressionUtils.objectToExpression(replacement)));
    }

    public OutType charLength() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.CHAR_LENGTH, this.toExpr()));
    }

    public OutType upperCase() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.UPPER, this.toExpr()));
    }

    public OutType lowerCase() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LOWER, this.toExpr()));
    }

    public OutType initCap() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.INIT_CAP, this.toExpr()));
    }

    public OutType like(InType pattern) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, this.toExpr(), ApiExpressionUtils.objectToExpression(pattern)));
    }

    public OutType similar(InType pattern) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.SIMILAR, this.toExpr(), ApiExpressionUtils.objectToExpression(pattern)));
    }

    public OutType position(InType haystack) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.POSITION, this.toExpr(), ApiExpressionUtils.objectToExpression(haystack)));
    }

    public OutType lpad(InType len, InType pad) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LPAD, this.toExpr(), ApiExpressionUtils.objectToExpression(len), ApiExpressionUtils.objectToExpression(pad)));
    }

    public OutType rpad(InType len, InType pad) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.RPAD, this.toExpr(), ApiExpressionUtils.objectToExpression(len), ApiExpressionUtils.objectToExpression(pad)));
    }

    public OutType over(InType alias) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.OVER, this.toExpr(), ApiExpressionUtils.objectToExpression(alias)));
    }

    public OutType overlay(InType newString, InType starting) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.OVERLAY, this.toExpr(), ApiExpressionUtils.objectToExpression(newString), ApiExpressionUtils.objectToExpression(starting)));
    }

    public OutType overlay(InType newString, InType starting, InType length) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.OVERLAY, this.toExpr(), ApiExpressionUtils.objectToExpression(newString), ApiExpressionUtils.objectToExpression(starting), ApiExpressionUtils.objectToExpression(length)));
    }

    public OutType regexpReplace(InType regex, InType replacement) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.REGEXP_REPLACE, this.toExpr(), ApiExpressionUtils.objectToExpression(regex), ApiExpressionUtils.objectToExpression(replacement)));
    }

    public OutType regexpExtract(InType regex, InType extractIndex) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.REGEXP_EXTRACT, this.toExpr(), ApiExpressionUtils.objectToExpression(regex), ApiExpressionUtils.objectToExpression(extractIndex)));
    }

    public OutType regexpExtract(InType regex) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.REGEXP_EXTRACT, this.toExpr(), ApiExpressionUtils.objectToExpression(regex)));
    }

    public OutType fromBase64() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.FROM_BASE64, this.toExpr()));
    }

    public OutType toBase64() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.TO_BASE64, this.toExpr()));
    }

    public OutType ltrim() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LTRIM, this.toExpr()));
    }

    public OutType rtrim() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.RTRIM, this.toExpr()));
    }

    public OutType repeat(InType n) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.REPEAT, this.toExpr(), ApiExpressionUtils.objectToExpression(n)));
    }

    public OutType toDate() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.CAST, new Expression[]{this.toExpr(), ApiExpressionUtils.typeLiteral(TypeConversions.fromLegacyInfoToDataType((TypeInformation)SqlTimeTypeInfo.DATE))}));
    }

    public OutType toTime() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.CAST, new Expression[]{this.toExpr(), ApiExpressionUtils.typeLiteral(TypeConversions.fromLegacyInfoToDataType((TypeInformation)SqlTimeTypeInfo.TIME))}));
    }

    public OutType toTimestamp() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.CAST, new Expression[]{this.toExpr(), ApiExpressionUtils.typeLiteral(TypeConversions.fromLegacyInfoToDataType((TypeInformation)SqlTimeTypeInfo.TIMESTAMP))}));
    }

    public OutType extract(TimeIntervalUnit timeIntervalUnit) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EXTRACT, new Expression[]{ApiExpressionUtils.valueLiteral(timeIntervalUnit), this.toExpr()}));
    }

    public OutType floor(TimeIntervalUnit timeIntervalUnit) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.FLOOR, new Expression[]{this.toExpr(), ApiExpressionUtils.valueLiteral(timeIntervalUnit)}));
    }

    public OutType ceil(TimeIntervalUnit timeIntervalUnit) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.CEIL, new Expression[]{this.toExpr(), ApiExpressionUtils.valueLiteral(timeIntervalUnit)}));
    }

    public OutType get(String name) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.GET, new Expression[]{this.toExpr(), ApiExpressionUtils.valueLiteral(name)}));
    }

    public OutType get(int index) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.GET, new Expression[]{this.toExpr(), ApiExpressionUtils.valueLiteral(index)}));
    }

    public OutType flatten() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.FLATTEN, this.toExpr()));
    }

    public OutType at(InType index) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.AT, this.toExpr(), ApiExpressionUtils.objectToExpression(index)));
    }

    public OutType cardinality() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.CARDINALITY, this.toExpr()));
    }

    public OutType element() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.ARRAY_ELEMENT, this.toExpr()));
    }

    public OutType rowtime() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.ROWTIME, this.toExpr()));
    }

    public OutType proctime() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.PROCTIME, this.toExpr()));
    }

    public OutType year() {
        return this.toApiSpecificExpression(ApiExpressionUtils.toMonthInterval(this.toExpr(), 12));
    }

    public OutType years() {
        return this.year();
    }

    public OutType quarter() {
        return this.toApiSpecificExpression(ApiExpressionUtils.toMonthInterval(this.toExpr(), 3));
    }

    public OutType quarters() {
        return this.quarter();
    }

    public OutType month() {
        return this.toApiSpecificExpression(ApiExpressionUtils.toMonthInterval(this.toExpr(), 1));
    }

    public OutType months() {
        return this.month();
    }

    public OutType week() {
        return this.toApiSpecificExpression(ApiExpressionUtils.toMilliInterval(this.toExpr(), 604800000L));
    }

    public OutType weeks() {
        return this.week();
    }

    public OutType day() {
        return this.toApiSpecificExpression(ApiExpressionUtils.toMilliInterval(this.toExpr(), 86400000L));
    }

    public OutType days() {
        return this.day();
    }

    public OutType hour() {
        return this.toApiSpecificExpression(ApiExpressionUtils.toMilliInterval(this.toExpr(), 3600000L));
    }

    public OutType hours() {
        return this.hour();
    }

    public OutType minute() {
        return this.toApiSpecificExpression(ApiExpressionUtils.toMilliInterval(this.toExpr(), 60000L));
    }

    public OutType minutes() {
        return this.minute();
    }

    public OutType second() {
        return this.toApiSpecificExpression(ApiExpressionUtils.toMilliInterval(this.toExpr(), 1000L));
    }

    public OutType seconds() {
        return this.second();
    }

    public OutType milli() {
        return this.toApiSpecificExpression(ApiExpressionUtils.toMilliInterval(this.toExpr(), 1L));
    }

    public OutType millis() {
        return this.milli();
    }

    public OutType md5() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.MD5, this.toExpr()));
    }

    public OutType sha1() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.SHA1, this.toExpr()));
    }

    public OutType sha224() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.SHA224, this.toExpr()));
    }

    public OutType sha256() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.SHA256, this.toExpr()));
    }

    public OutType sha384() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.SHA384, this.toExpr()));
    }

    public OutType sha512() {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.SHA512, this.toExpr()));
    }

    public OutType sha2(InType hashLength) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.SHA2, this.toExpr(), ApiExpressionUtils.objectToExpression(hashLength)));
    }

    public OutType jsonExists(String path, JsonExistsOnError onError) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.JSON_EXISTS, new Expression[]{this.toExpr(), ApiExpressionUtils.valueLiteral(path), ApiExpressionUtils.valueLiteral(onError)}));
    }

    public OutType jsonExists(String path) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.JSON_EXISTS, new Expression[]{this.toExpr(), ApiExpressionUtils.valueLiteral(path)}));
    }

    public OutType jsonValue(String path, DataType returningType, JsonValueOnEmptyOrError onEmpty, InType defaultOnEmpty, JsonValueOnEmptyOrError onError, InType defaultOnError) {
        return this.toApiSpecificExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.JSON_VALUE, new Expression[]{this.toExpr(), ApiExpressionUtils.valueLiteral(path), ApiExpressionUtils.typeLiteral(returningType), ApiExpressionUtils.valueLiteral(onEmpty), ApiExpressionUtils.objectToExpression(defaultOnEmpty), ApiExpressionUtils.valueLiteral(onError), ApiExpressionUtils.objectToExpression(defaultOnError)}));
    }

    public OutType jsonValue(String path, DataType returningType) {
        return this.jsonValue(path, returningType, JsonValueOnEmptyOrError.NULL, null, JsonValueOnEmptyOrError.NULL, null);
    }

    public OutType jsonValue(String path, DataType returningType, InType defaultOnEmptyOrError) {
        return this.jsonValue(path, returningType, JsonValueOnEmptyOrError.DEFAULT, defaultOnEmptyOrError, JsonValueOnEmptyOrError.DEFAULT, defaultOnEmptyOrError);
    }

    public OutType jsonValue(String path) {
        return this.jsonValue(path, DataTypes.STRING());
    }
}

