/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.math.MathContext;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.table.api.PlannerConfig;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class TableConfig {
    private ZoneId localZoneId = ZoneId.systemDefault();
    private Boolean nullCheck = true;
    private PlannerConfig plannerConfig = PlannerConfig.EMPTY_CONFIG;
    private MathContext decimalContext = MathContext.DECIMAL128;
    private Integer maxGeneratedCodeLength = 64000;
    private long minIdleStateRetentionTime = 0L;
    private long maxIdleStateRetentionTime = 0L;
    private Configuration configuration = new Configuration();
    private SqlDialect sqlDialect = SqlDialect.DEFAULT;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void addConfiguration(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        this.configuration.addAll(configuration);
    }

    public SqlDialect getSqlDialect() {
        return this.sqlDialect;
    }

    public void setSqlDialect(SqlDialect sqlDialect) {
        this.sqlDialect = sqlDialect;
    }

    public ZoneId getLocalTimeZone() {
        return this.localZoneId;
    }

    public void setLocalTimeZone(ZoneId zoneId) {
        this.localZoneId = (ZoneId)Preconditions.checkNotNull((Object)zoneId);
    }

    public Boolean getNullCheck() {
        return this.nullCheck;
    }

    public void setNullCheck(Boolean nullCheck) {
        this.nullCheck = (Boolean)Preconditions.checkNotNull((Object)nullCheck);
    }

    public PlannerConfig getPlannerConfig() {
        return this.plannerConfig;
    }

    public void setPlannerConfig(PlannerConfig plannerConfig) {
        this.plannerConfig = (PlannerConfig)Preconditions.checkNotNull((Object)plannerConfig);
    }

    public MathContext getDecimalContext() {
        return this.decimalContext;
    }

    public void setDecimalContext(MathContext decimalContext) {
        this.decimalContext = (MathContext)Preconditions.checkNotNull((Object)decimalContext);
    }

    public Integer getMaxGeneratedCodeLength() {
        return this.maxGeneratedCodeLength;
    }

    public void setMaxGeneratedCodeLength(Integer maxGeneratedCodeLength) {
        this.maxGeneratedCodeLength = (Integer)Preconditions.checkNotNull((Object)maxGeneratedCodeLength);
    }

    public void setIdleStateRetentionTime(Time minTime, Time maxTime) {
        if (maxTime.toMilliseconds() - minTime.toMilliseconds() < 300000L && (maxTime.toMilliseconds() != 0L || minTime.toMilliseconds() != 0L)) {
            throw new IllegalArgumentException("Difference between minTime: " + minTime.toString() + " and maxTime: " + maxTime.toString() + "shoud be at least 5 minutes.");
        }
        this.minIdleStateRetentionTime = minTime.toMilliseconds();
        this.maxIdleStateRetentionTime = maxTime.toMilliseconds();
    }

    public long getMinIdleStateRetentionTime() {
        return this.minIdleStateRetentionTime;
    }

    public long getMaxIdleStateRetentionTime() {
        return this.maxIdleStateRetentionTime;
    }

    @Experimental
    public void addJobParameter(String key, String value) {
        Map params = this.getConfiguration().getOptional(PipelineOptions.GLOBAL_JOB_PARAMETERS).map(HashMap::new).orElseGet(HashMap::new);
        params.put(key, value);
        this.getConfiguration().set(PipelineOptions.GLOBAL_JOB_PARAMETERS, (Object)params);
    }

    public static TableConfig getDefault() {
        return new TableConfig();
    }
}

