/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableAggregateFunctionDefinition;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.functions.UserDefinedFunction;

public class FunctionDefinitionUtil {
    public static FunctionDefinition createFunctionDefinition(String name, String className) {
        Object func;
        try {
            func = Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(String.format("Failed instantiating '%s'", className), e);
        }
        UserDefinedFunction udf = (UserDefinedFunction)func;
        if (udf instanceof ScalarFunction) {
            return new ScalarFunctionDefinition(name, (ScalarFunction)udf);
        }
        if (udf instanceof TableFunction) {
            TableFunction t = (TableFunction)udf;
            return new TableFunctionDefinition(name, t, t.getResultType());
        }
        if (udf instanceof AggregateFunction) {
            AggregateFunction a = (AggregateFunction)udf;
            return new AggregateFunctionDefinition(name, a, a.getAccumulatorType(), a.getResultType());
        }
        if (udf instanceof TableAggregateFunction) {
            TableAggregateFunction a = (TableAggregateFunction)udf;
            return new TableAggregateFunctionDefinition(name, a, a.getAccumulatorType(), a.getResultType());
        }
        throw new UnsupportedOperationException(String.format("Function %s should be of ScalarFunction, TableFunction, AggregateFunction, or TableAggregateFunction", className));
    }
}

