/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.inference.StateTypeStrategy;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.inference.TypeStrategy;

@Internal
interface FunctionResultTemplate {
    public static FunctionOutputTemplate ofOutput(DataType dataType) {
        return new FunctionOutputTemplate(dataType);
    }

    public static FunctionStateTemplate ofState(LinkedHashMap<String, DataType> state) {
        return new FunctionStateTemplate(state);
    }

    @Internal
    public static class FunctionStateTemplate
    implements FunctionResultTemplate {
        private final LinkedHashMap<String, DataType> state;

        private FunctionStateTemplate(LinkedHashMap<String, DataType> state) {
            this.state = state;
        }

        List<Class<?>> toClassList() {
            return this.state.values().stream().map(DataType::getConversionClass).collect(Collectors.toList());
        }

        LinkedHashMap<String, StateTypeStrategy> toStateTypeStrategies() {
            return this.state.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> FunctionStateTemplate.createStateTypeStrategy((DataType)e.getValue()), (o, n) -> o, LinkedHashMap::new));
        }

        String toAccumulatorStateName() {
            this.checkSingleStateEntry();
            return this.state.keySet().iterator().next();
        }

        TypeStrategy toAccumulatorTypeStrategy() {
            this.checkSingleStateEntry();
            return FunctionStateTemplate.createTypeStrategy(this.state.values().iterator().next());
        }

        private void checkSingleStateEntry() {
            if (this.state.size() != 1) {
                throw ExtractionUtils.extractionError("Aggregating functions support only one state entry.", new Object[0]);
            }
        }

        private static StateTypeStrategy createStateTypeStrategy(DataType dataType) {
            return StateTypeStrategy.of(TypeStrategies.explicit(dataType));
        }

        private static TypeStrategy createTypeStrategy(DataType dataType) {
            return TypeStrategies.explicit(dataType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionStateTemplate that = (FunctionStateTemplate)o;
            return Objects.equals(this.state, that.state);
        }

        public int hashCode() {
            return Objects.hash(this.state);
        }
    }

    @Internal
    public static class FunctionOutputTemplate
    implements FunctionResultTemplate {
        private final DataType dataType;

        private FunctionOutputTemplate(DataType dataType) {
            this.dataType = dataType;
        }

        TypeStrategy toTypeStrategy() {
            return TypeStrategies.explicit(this.dataType);
        }

        Class<?> toClass() {
            return this.dataType.getConversionClass();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionOutputTemplate template = (FunctionOutputTemplate)o;
            return Objects.equals(this.dataType, template.dataType);
        }

        public int hashCode() {
            return Objects.hash(this.dataType);
        }
    }
}

