/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.resource.ResourceUri;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@Internal
public class CatalogFunctionImpl
implements CatalogFunction {
    private final String className;
    private final FunctionLanguage functionLanguage;
    private final List<ResourceUri> resourceUris;

    public CatalogFunctionImpl(String className) {
        this(className, FunctionLanguage.JAVA, Collections.emptyList());
    }

    public CatalogFunctionImpl(String className, FunctionLanguage functionLanguage) {
        this(className, functionLanguage, Collections.emptyList());
    }

    public CatalogFunctionImpl(String className, FunctionLanguage functionLanguage, List<ResourceUri> resourceUris) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)className) ? 1 : 0) != 0, (Object)"className cannot be null or empty");
        this.className = className;
        this.functionLanguage = (FunctionLanguage)((Object)Preconditions.checkNotNull((Object)((Object)functionLanguage), (String)"functionLanguage cannot be null"));
        this.resourceUris = resourceUris;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public CatalogFunction copy() {
        return new CatalogFunctionImpl(this.getClassName(), this.functionLanguage, Collections.unmodifiableList(this.resourceUris));
    }

    @Override
    public Optional<String> getDescription() {
        return Optional.of("This is a user-defined function");
    }

    @Override
    public Optional<String> getDetailedDescription() {
        return Optional.of("This is a user-defined function");
    }

    @Override
    public boolean isGeneric() {
        if (this.functionLanguage == FunctionLanguage.PYTHON) {
            return true;
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> c = Class.forName(this.className, true, cl);
            if (UserDefinedFunction.class.isAssignableFrom(c)) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Can't resolve udf class %s", this.className), e);
        }
        return false;
    }

    @Override
    public FunctionLanguage getFunctionLanguage() {
        return this.functionLanguage;
    }

    @Override
    public List<ResourceUri> getFunctionResources() {
        return this.resourceUris;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogFunctionImpl that = (CatalogFunctionImpl)o;
        return Objects.equals(this.className, that.className) && this.functionLanguage == that.functionLanguage && Objects.equals(this.resourceUris, that.resourceUris);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.className, this.functionLanguage, this.resourceUris});
    }

    public String toString() {
        return "CatalogFunctionImpl{className='" + this.getClassName() + "', functionLanguage='" + (Object)((Object)this.getFunctionLanguage()) + "', functionResource='" + this.getFunctionResources() + "'}";
    }
}

