/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.types.extraction.DataTypeTemplate;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.extraction.FunctionArgumentTemplate;
import org.apache.flink.table.types.extraction.FunctionResultTemplate;
import org.apache.flink.table.types.extraction.FunctionSignatureTemplate;

@Internal
final class FunctionTemplate {
    @Nullable
    private final FunctionSignatureTemplate signatureTemplate;
    @Nullable
    private final FunctionResultTemplate accumulatorTemplate;
    @Nullable
    private final FunctionResultTemplate outputTemplate;

    private FunctionTemplate(@Nullable FunctionSignatureTemplate signatureTemplate, @Nullable FunctionResultTemplate accumulatorTemplate, @Nullable FunctionResultTemplate outputTemplate) {
        this.signatureTemplate = signatureTemplate;
        this.accumulatorTemplate = accumulatorTemplate;
        this.outputTemplate = outputTemplate;
    }

    static FunctionTemplate fromAnnotation(DataTypeFactory typeFactory, FunctionHint hint) {
        return new FunctionTemplate(FunctionTemplate.createSignatureTemplate(typeFactory, FunctionTemplate.defaultAsNull(hint, FunctionHint::input), FunctionTemplate.defaultAsNull(hint, FunctionHint::argumentNames), FunctionTemplate.defaultAsNull(hint, FunctionHint::argument), hint.isVarArgs()), FunctionTemplate.createResultTemplate(typeFactory, FunctionTemplate.defaultAsNull(hint, FunctionHint::accumulator)), FunctionTemplate.createResultTemplate(typeFactory, FunctionTemplate.defaultAsNull(hint, FunctionHint::output)));
    }

    static FunctionTemplate fromAnnotation(DataTypeFactory typeFactory, ProcedureHint hint) {
        return new FunctionTemplate(FunctionTemplate.createSignatureTemplate(typeFactory, FunctionTemplate.defaultAsNull(hint, ProcedureHint::input), FunctionTemplate.defaultAsNull(hint, ProcedureHint::argumentNames), FunctionTemplate.defaultAsNull(hint, ProcedureHint::argument), hint.isVarArgs()), null, FunctionTemplate.createResultTemplate(typeFactory, FunctionTemplate.defaultAsNull(hint, ProcedureHint::output)));
    }

    @Nullable
    static FunctionResultTemplate createResultTemplate(DataTypeFactory typeFactory, @Nullable DataTypeHint hint) {
        DataTypeTemplate template;
        if (hint == null) {
            return null;
        }
        try {
            template = DataTypeTemplate.fromAnnotation(typeFactory, hint);
        }
        catch (Throwable t) {
            throw ExtractionUtils.extractionError(t, "Error in data type hint annotation.", new Object[0]);
        }
        if (template.dataType != null) {
            return FunctionResultTemplate.of(template.dataType);
        }
        throw ExtractionUtils.extractionError("Data type hint does not specify a data type for use as function result.", new Object[0]);
    }

    @Nullable
    FunctionSignatureTemplate getSignatureTemplate() {
        return this.signatureTemplate;
    }

    @Nullable
    FunctionResultTemplate getAccumulatorTemplate() {
        return this.accumulatorTemplate;
    }

    @Nullable
    FunctionResultTemplate getOutputTemplate() {
        return this.outputTemplate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionTemplate template = (FunctionTemplate)o;
        return Objects.equals(this.signatureTemplate, template.signatureTemplate) && Objects.equals(this.accumulatorTemplate, template.accumulatorTemplate) && Objects.equals(this.outputTemplate, template.outputTemplate);
    }

    public int hashCode() {
        return Objects.hash(this.signatureTemplate, this.accumulatorTemplate, this.outputTemplate);
    }

    private static <H extends Annotation> H getDefaultAnnotation(Class<H> hClass) {
        return DefaultAnnotationHelper.class.getAnnotation(hClass);
    }

    private static <T> T defaultAsNull(FunctionHint hint, Function<FunctionHint, T> accessor) {
        return FunctionTemplate.defaultAsNull(hint, FunctionTemplate.getDefaultAnnotation(FunctionHint.class), accessor);
    }

    private static <T> T defaultAsNull(ProcedureHint hint, Function<ProcedureHint, T> accessor) {
        return FunctionTemplate.defaultAsNull(hint, FunctionTemplate.getDefaultAnnotation(ProcedureHint.class), accessor);
    }

    private static <T> T defaultAsNull(ArgumentHint hint, Function<ArgumentHint, T> accessor) {
        return FunctionTemplate.defaultAsNull(hint, FunctionTemplate.getDefaultAnnotation(ArgumentHint.class), accessor);
    }

    private static <T, H extends Annotation> T defaultAsNull(H hint, H defaultHint, Function<H, T> accessor) {
        T actualValue;
        T defaultValue = accessor.apply(defaultHint);
        if (Objects.deepEquals(defaultValue, actualValue = accessor.apply(hint))) {
            return null;
        }
        return actualValue;
    }

    @Nullable
    private static FunctionSignatureTemplate createSignatureTemplate(DataTypeFactory typeFactory, @Nullable DataTypeHint[] inputs, @Nullable String[] argumentNames, @Nullable ArgumentHint[] argumentHints, boolean isVarArg) {
        DataTypeHint[] argumentHintTypes;
        String[] argumentHintNames;
        if (argumentHints != null && inputs != null) {
            throw ExtractionUtils.extractionError("Argument and input hints cannot be declared in the same function hint.", new Object[0]);
        }
        Object[] argumentOptionals = null;
        if (argumentHints != null) {
            argumentHintNames = new String[argumentHints.length];
            argumentHintTypes = new DataTypeHint[argumentHints.length];
            argumentOptionals = new Boolean[argumentHints.length];
            boolean allArgumentNameNotSet = true;
            for (int i = 0; i < argumentHints.length; ++i) {
                ArgumentHint argumentHint = argumentHints[i];
                argumentHintNames[i] = FunctionTemplate.defaultAsNull(argumentHint, ArgumentHint::name);
                argumentHintTypes[i] = FunctionTemplate.defaultAsNull(argumentHint, ArgumentHint::type);
                argumentOptionals[i] = argumentHint.isOptional();
                if (argumentHintTypes[i] == null) {
                    throw ExtractionUtils.extractionError("The type of the argument at position %d is not set.", i);
                }
                if (argumentHintNames[i] != null) {
                    allArgumentNameNotSet = false;
                    continue;
                }
                if (allArgumentNameNotSet) continue;
                throw ExtractionUtils.extractionError("The argument name in function hint must be either fully set or not set at all.", new Object[0]);
            }
            if (allArgumentNameNotSet) {
                argumentHintNames = null;
            }
        } else {
            if (inputs == null) {
                return null;
            }
            argumentHintTypes = inputs;
            argumentHintNames = argumentNames;
            argumentOptionals = new Boolean[inputs.length];
            Arrays.fill(argumentOptionals, (Object)false);
        }
        return FunctionSignatureTemplate.of(Arrays.stream(argumentHintTypes).map(dataTypeHint -> FunctionTemplate.createArgumentTemplate(typeFactory, dataTypeHint)).collect(Collectors.toList()), isVarArg, argumentHintNames, (Boolean[])argumentOptionals);
    }

    private static FunctionArgumentTemplate createArgumentTemplate(DataTypeFactory typeFactory, DataTypeHint hint) {
        DataTypeTemplate template = DataTypeTemplate.fromAnnotation(typeFactory, hint);
        if (template.dataType != null) {
            return FunctionArgumentTemplate.of(template.dataType);
        }
        if (template.inputGroup != null) {
            return FunctionArgumentTemplate.of(template.inputGroup);
        }
        throw ExtractionUtils.extractionError("Data type hint does neither specify a data type nor input group for use as function argument.", new Object[0]);
    }

    @ProcedureHint
    @FunctionHint
    @ArgumentHint
    private static class DefaultAnnotationHelper {
        private DefaultAnnotationHelper() {
        }
    }
}

